/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.asm.patch;

import com.charles445.rltweaker.asm.helper.ASMHelper;
import com.charles445.rltweaker.asm.patch.Patch;
import com.charles445.rltweaker.asm.patch.PatchManager;
import com.charles445.rltweaker.asm.util.ASMInfo;
import com.charles445.rltweaker.asm.util.ASMLogger;
import com.charles445.rltweaker.asm.util.TransformUtil;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class PatchPathfindingChunkCache
extends PatchManager {
    public PatchPathfindingChunkCache() {
        super("Pathfinding Chunk Cache");
        this.add(new Patch(this, "net.minecraft.world.ChunkCache", 1){

            @Override
            public void patch(ClassNode clazzNode) {
                if (ASMInfo.hasSponge) {
                    ASMLogger.info("Sponge was detected, skipping patch");
                    this.cancelled = true;
                    return;
                }
                MethodNode m_init = this.findMethod(clazzNode, "<init>");
                if (m_init == null) {
                    throw new RuntimeException("Couldn't find init for ChunkCache... that's not good");
                }
                MethodInsnNode toCall = TransformUtil.findNextCallWithOpcodeAndName(this.first(m_init), 182, "func_72964_e", "getChunkFromChunkCoords");
                if (toCall == null) {
                    throw new RuntimeException("Couldn't find func_72964_e or getChunkFromChunkCoords in ChunkCache init");
                }
                this.insertBefore(m_init, (AbstractInsnNode)toCall, (AbstractInsnNode)new VarInsnNode(25, 0));
                toCall.setOpcode(184);
                toCall.owner = "com/charles445/rltweaker/hook/HookMinecraft";
                toCall.name = "cacheGetChunkFromChunkCoords";
                toCall.desc = "(Lnet/minecraft/world/World;IILnet/minecraft/world/ChunkCache;)Lnet/minecraft/world/chunk/Chunk;";
            }
        });
        this.add(new Patch(this, "net.minecraft.pathfinding.PathNavigate", 1){

            @Override
            public void patch(ClassNode clazzNode) {
                if (ASMInfo.hasSponge) {
                    ASMLogger.info("Sponge was detected, skipping patch");
                    this.cancelled = true;
                    return;
                }
                MethodNode m_getPathToPos = this.findMethod(clazzNode, "func_179680_a", "getPathToPos");
                if (m_getPathToPos == null) {
                    throw new RuntimeException("Couldn't find func_179680_a or getPathToPos");
                }
                TypeInsnNode newNode = (TypeInsnNode)ASMHelper.findNextInstructionWithOpcode(this.first(m_getPathToPos), 187);
                if (newNode == null) {
                    throw new RuntimeException("Couldn't find any instantiation in func_179680_a or getPathToPos");
                }
                while (!newNode.desc.equals("net/minecraft/world/ChunkCache")) {
                    if ((newNode = (TypeInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)newNode, 187)) != null) continue;
                    throw new RuntimeException("Failed to find ChunkCache instantiation new in func_179680_a or getPathToPo");
                }
                newNode.desc = "com/charles445/rltweaker/hook/NullableChunkCache";
                MethodInsnNode callInit = TransformUtil.findNextCallWithOpcodeAndName((AbstractInsnNode)newNode, 183, "<init>");
                while (!callInit.owner.equals("net/minecraft/world/ChunkCache")) {
                    if ((callInit = TransformUtil.findNextCallWithOpcodeAndName((AbstractInsnNode)callInit, 183, "<init>")) != null) continue;
                    throw new RuntimeException("Failed to find ChunkCache instantiation call in func_179680_a or getPathToPo");
                }
                callInit.owner = "com/charles445/rltweaker/hook/NullableChunkCache";
                MethodNode m_getPathToEntityLiving = this.findMethod(clazzNode, "func_75494_a", "getPathToEntityLiving");
                newNode = (TypeInsnNode)ASMHelper.findNextInstructionWithOpcode(this.first(m_getPathToEntityLiving), 187);
                while (!newNode.desc.equals("net/minecraft/world/ChunkCache")) {
                    if ((newNode = (TypeInsnNode)ASMHelper.findNextInstructionWithOpcode((AbstractInsnNode)newNode, 187)) != null) continue;
                    throw new RuntimeException("Failed to find ChunkCache instantiation new in func_75494_a or getPathToEntityLiving");
                }
                newNode.desc = "com/charles445/rltweaker/hook/NullableChunkCache";
                callInit = TransformUtil.findNextCallWithOpcodeAndName((AbstractInsnNode)newNode, 183, "<init>");
                while (!callInit.owner.equals("net/minecraft/world/ChunkCache")) {
                    if ((callInit = TransformUtil.findNextCallWithOpcodeAndName((AbstractInsnNode)callInit, 183, "<init>")) != null) continue;
                    throw new RuntimeException("Failed to find ChunkCache instantiation call in func_75494_a or getPathToEntityLiving");
                }
                callInit.owner = "com/charles445/rltweaker/hook/NullableChunkCache";
            }
        });
    }
}

