/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.selection.selector;

import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxesSimple;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.selection.selector.AndSelector;
import com.creativemd.littletiles.common.util.selection.selector.AnySelector;
import com.creativemd.littletiles.common.util.selection.selector.ColorSelector;
import com.creativemd.littletiles.common.util.selection.selector.NoStructureSelector;
import com.creativemd.littletiles.common.util.selection.selector.NotSelector;
import com.creativemd.littletiles.common.util.selection.selector.OrSelector;
import com.creativemd.littletiles.common.util.selection.selector.StateSelector;
import com.creativemd.littletiles.common.util.selection.selector.TileSelectorBlock;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class TileSelector {
    private static HashMap<String, Class<? extends TileSelector>> selectorTypes = new HashMap();

    public static void registerType(String id, Class<? extends TileSelector> type) {
        selectorTypes.put(id, type);
    }

    public static String getTypeID(Class<? extends TileSelector> type) {
        for (Map.Entry<String, Class<? extends TileSelector>> entry : selectorTypes.entrySet()) {
            if (type != entry.getValue()) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Class<? extends TileSelector> getType(String id) {
        return selectorTypes.get(id);
    }

    public static TileSelector loadSelector(String id, NBTTagCompound nbt) {
        Class<? extends TileSelector> type = TileSelector.getType(id);
        if (type != null) {
            try {
                TileSelector selector = type.getConstructor(new Class[0]).newInstance(new Object[0]);
                selector.loadNBT(nbt);
                return selector;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Selector type " + nbt.func_74779_i("type") + " is missing an empty constructor!");
            }
        }
        System.out.println("Selector " + nbt.func_74779_i("type") + " could not be found!");
        return null;
    }

    public static TileSelector loadSelector(NBTTagCompound nbt) {
        Class<? extends TileSelector> type = TileSelector.getType(nbt.func_74779_i("type"));
        if (type != null) {
            try {
                TileSelector selector = type.getConstructor(new Class[0]).newInstance(new Object[0]);
                selector.loadNBT(nbt);
                return selector;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Selector type " + nbt.func_74779_i("type") + " is missing an empty constructor!");
            }
        }
        System.out.println("Selector " + nbt.func_74779_i("type") + " could not be found!");
        return null;
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        this.saveNBT(nbt);
        nbt.func_74778_a("type", TileSelector.getTypeID(this.getClass()));
        return nbt;
    }

    protected abstract void saveNBT(NBTTagCompound var1);

    protected abstract void loadNBT(NBTTagCompound var1);

    public abstract boolean is(IParentTileList var1, LittleTile var2);

    public static LittleBoxes getAbsoluteBoxes(World world, BlockPos pos, BlockPos pos2, TileSelector selector) {
        LittleBoxesSimple boxes = new LittleBoxesSimple(pos, LittleGridContext.getMin());
        int minX = Math.min(pos.func_177958_n(), pos2.func_177958_n());
        int maxX = Math.max(pos.func_177958_n(), pos2.func_177958_n());
        int minY = Math.min(pos.func_177956_o(), pos2.func_177956_o());
        int maxY = Math.max(pos.func_177956_o(), pos2.func_177956_o());
        int minZ = Math.min(pos.func_177952_p(), pos2.func_177952_p());
        int maxZ = Math.max(pos.func_177952_p(), pos2.func_177952_p());
        BlockPos.MutableBlockPos position = new BlockPos.MutableBlockPos();
        for (int posX = minX; posX <= maxX; ++posX) {
            for (int posY = minY; posY <= maxY; ++posY) {
                for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                    position.func_181079_c(posX, posY, posZ);
                    TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, (BlockPos)position);
                    if (te == null) continue;
                    for (Pair<IParentTileList, LittleTile> pair : te.allTiles()) {
                        if (!selector.is((IParentTileList)pair.key, (LittleTile)pair.value)) continue;
                        ((LittleBoxes)boxes).addBox((IParentTileList)pair.key, (LittleTile)pair.value);
                    }
                }
            }
        }
        return boxes;
    }

    public static List<LittleBox> getBoxes(World world, BlockPos pos, TileSelector selector) {
        ArrayList<LittleBox> boxes = new ArrayList<LittleBox>();
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        for (Pair<IParentTileList, LittleTile> pair : te.allTiles()) {
            if (!selector.is((IParentTileList)pair.key, (LittleTile)pair.value)) continue;
            boxes.add(((LittleTile)pair.value).getBox());
        }
        return boxes;
    }

    static {
        TileSelector.registerType("any", AnySelector.class);
        TileSelector.registerType("and", AndSelector.class);
        TileSelector.registerType("or", OrSelector.class);
        TileSelector.registerType("not", NotSelector.class);
        TileSelector.registerType("block", TileSelectorBlock.class);
        TileSelector.registerType("state", StateSelector.class);
        TileSelector.registerType("color", ColorSelector.class);
        TileSelector.registerType("nostructure", NoStructureSelector.class);
    }
}

