/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.math.box;

import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import net.minecraft.util.EnumFacing;

public class LittleBoxReturnedVolume {
    private int volume;

    public void addPixel() {
        ++this.volume;
    }

    public void addDifBox(LittleBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int sizeX = maxX - minX - box.getSize(EnumFacing.Axis.X);
        int sizeY = maxY - minY - box.getSize(EnumFacing.Axis.Y);
        int sizeZ = maxZ - minZ - box.getSize(EnumFacing.Axis.Z);
        this.volume += sizeX * sizeY * sizeZ;
    }

    public void addBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.volume += (maxX - minX) * (maxY - minY) * (maxZ - minZ);
    }

    public boolean has() {
        return this.volume > 0;
    }

    public int getVolume() {
        return this.volume;
    }

    public double getPercentVolume(LittleGridContext context) {
        return (double)this.volume / (double)context.maxTilesPerBlock;
    }

    public void clear() {
        this.volume = 0;
    }

    public LittlePreview createFakePreview(LittlePreview preview) {
        LittlePreview copy = preview.copy();
        copy.setBox(new LittleBox(0, 0, 0, this.volume, 1, 1));
        return copy;
    }

    public LittleTile createFakeTile(LittleTile tile) {
        LittleTile copy = tile.copy();
        copy.setBox(new LittleBox(0, 0, 0, this.volume, 1, 1));
        return copy;
    }
}

