/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.animation;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.littletiles.common.structure.animation.AnimationKey;
import com.creativemd.littletiles.common.structure.animation.AnimationState;
import com.creativemd.littletiles.common.structure.animation.AnimationTimeline;
import com.creativemd.littletiles.common.structure.animation.ValueTimeline;
import com.creativemd.littletiles.common.util.vec.LittleTransformation;
import java.util.HashMap;
import net.minecraft.util.EnumFacing;

public class AnimationController {
    protected HashMap<String, AnimationControllerState> states = new HashMap();
    protected HashMap<String, AnimationTimeline> stateTransition = new HashMap();
    protected AnimationControllerState currentState;
    protected AnimationControllerState aimedState;
    protected int tick;
    protected AnimationState tickingState;
    protected AnimationTimeline animation;

    public AnimationController addStateAndSelect(String name, AnimationState state) {
        AnimationControllerState controllerState = new AnimationControllerState(name, state);
        this.states.put(name, controllerState);
        this.currentState = controllerState;
        return this;
    }

    public AnimationController addState(String name, AnimationState state) {
        this.states.put(name, new AnimationControllerState(name, state));
        return this;
    }

    public AnimationController generateAllTransistions(int duration) {
        for (String key : this.states.keySet()) {
            for (String key2 : this.states.keySet()) {
                if (key.equals(key2)) continue;
                this.generateTransition(key, key2, duration);
            }
        }
        return this;
    }

    public AnimationTimeline getAnimation() {
        return this.animation;
    }

    public AnimationControllerState getCurrentState() {
        return this.currentState;
    }

    public AnimationControllerState getAimedState() {
        return this.aimedState;
    }

    public int getInterpolationType() {
        return 0;
    }

    public AnimationController generateTransition(String from, String to, int duration) {
        ValueTimeline timeline;
        AnimationControllerState fromState = this.states.get(from);
        if (fromState == null) {
            throw new RuntimeException("State '" + from + "' does not exist");
        }
        AnimationControllerState toState = this.states.get(to);
        if (toState == null) {
            throw new RuntimeException("State '" + to + "' does not exist");
        }
        PairList values = new PairList();
        for (Pair pair : fromState.state.getValues()) {
            timeline = ValueTimeline.create(this.getInterpolationType());
            timeline.points.add((Object)0, pair.value);
            if (toState.state.getValues().containsKey(pair.key)) {
                timeline.points.add((Object)duration, toState.state.getValues().getValue(pair.key));
            } else {
                timeline.points.add((Object)duration, (Object)((AnimationKey)pair.key).getDefault());
            }
            values.add(pair.key, (Object)timeline);
        }
        for (Pair pair : toState.state.getValues()) {
            if (values.containsKey(pair.key)) continue;
            timeline = ValueTimeline.create(this.getInterpolationType());
            timeline.points.add((Object)0, (Object)((AnimationKey)pair.key).getDefault());
            timeline.points.add((Object)duration, pair.value);
            values.add(pair.key, (Object)timeline);
        }
        this.stateTransition.put(from + ":" + to, new AnimationTimeline(duration, (PairList<AnimationKey, ValueTimeline>)values));
        return this;
    }

    public AnimationController removeTransition(String from, String to) {
        this.stateTransition.remove(from + ":" + to);
        return this;
    }

    public AnimationController addTransition(String from, String to, AnimationTimeline animation) {
        return this.addTransition(from + ":" + to, animation);
    }

    public AnimationController addTransition(String key, AnimationTimeline animation) {
        this.stateTransition.put(key, animation);
        return this;
    }

    public boolean isChanging() {
        return this.aimedState != null;
    }

    public AnimationControllerState getState(String key) {
        return this.states.get(key);
    }

    public boolean hasState(String key) {
        return this.states.containsKey(key);
    }

    public void startTransition(String key) {
        AnimationControllerState state = this.states.get(key);
        if (state == null) {
            throw new RuntimeException("State '" + key + "' does not exist");
        }
        this.tick = 0;
        this.tickingState = new AnimationState();
        this.aimedState = state;
        this.animation = this.stateTransition.get(this.currentState.name + ":" + this.aimedState.name);
        if (this.animation == null) {
            throw new RuntimeException("Couldn't animate from '" + this.currentState.name + "' to '" + this.aimedState.name + "'");
        }
    }

    public void endTransition() {
        this.currentState = this.aimedState;
        this.animation = null;
        this.aimedState = null;
        this.tickingState = null;
    }

    public AnimationState getTickingState() {
        if (this.isChanging()) {
            this.animation.tick(this.tick, this.tickingState);
            return this.tickingState;
        }
        return this.currentState.state;
    }

    public AnimationState tick() {
        if (this.isChanging()) {
            if (this.animation.tick(this.tick, this.tickingState)) {
                ++this.tick;
                return this.tickingState;
            }
            this.endTransition();
        }
        return this.currentState.state;
    }

    public String toString() {
        if (this.isChanging()) {
            return "[" + this.currentState.name + "->" + this.tick + "->" + this.aimedState.name + "]";
        }
        return this.currentState.name;
    }

    public static class AnimationControllerState {
        public String name;
        public AnimationState state;

        public AnimationControllerState(String name, AnimationState state) {
            this.name = name;
            this.state = state;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof AnimationControllerState) {
                return this.name.equals(((AnimationControllerState)obj).name);
            }
            return false;
        }

        public void transform(LittleTransformation transformation) {
            int i;
            Rotation rotation;
            if (transformation.rotX != 0) {
                rotation = transformation.getRotation(EnumFacing.Axis.X);
                for (i = 0; i < Math.abs(transformation.rotX); ++i) {
                    this.state.transform(rotation);
                }
            }
            if (transformation.rotY != 0) {
                rotation = transformation.getRotation(EnumFacing.Axis.Y);
                for (i = 0; i < Math.abs(transformation.rotY); ++i) {
                    this.state.transform(rotation);
                }
            }
            if (transformation.rotZ != 0) {
                rotation = transformation.getRotation(EnumFacing.Axis.Z);
                for (i = 0; i < Math.abs(transformation.rotZ); ++i) {
                    this.state.transform(rotation);
                }
            }
        }
    }
}

