/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.item;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.client.gui.configure.SubGuiModeSelector;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.api.ILittlePlacer;
import com.creativemd.littletiles.common.item.ItemMultiTiles;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tile.registry.LittleTileRegistry;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementHelper;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockTiles
extends ItemBlock
implements ILittlePlacer,
ICreativeRendered {
    public ItemBlockTiles(Block block, ResourceLocation location) {
        super(block);
        this.func_77655_b(location.func_110623_a());
        this.field_77787_bX = true;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77667_c(ItemStack stack) {
        LittlePreview preview;
        if (stack.func_77942_o() && (preview = LittleTileRegistry.loadPreview(stack.func_77978_p())).getBlock() != null) {
            return new ItemStack(preview.getBlock(), 1, preview.getMeta()).func_77977_a();
        }
        return super.func_77667_c(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
    }

    @Override
    public boolean hasLittlePreview(ItemStack stack) {
        return true;
    }

    @Override
    public LittlePreviews getLittlePreview(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        LittlePreviews previews = new LittlePreviews(this.getPreviewsContext(stack));
        previews.addWithoutCheckingPreview(LittleTileRegistry.loadPreview(stack.func_77978_p()));
        return previews;
    }

    @Override
    public void saveLittlePreview(ItemStack stack, LittlePreviews previews) {
        if (previews.size() > 0) {
            LittlePreview preview = previews.get(0);
            NBTTagCompound nbt = preview.getTileData().func_74737_b();
            previews.getContext().set(nbt);
            LittleBox tempBox = preview.box;
            preview.box = preview.box.copy();
            preview.box.sub(preview.box.getMinVec());
            preview.writeToNBT(nbt);
            preview.box = tempBox;
            stack.func_77982_d(nbt);
        } else {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public static ItemStack getStackFromPreview(LittleGridContext context, LittlePreview preview) {
        ItemStack stack = new ItemStack(LittleTiles.blockTileNoTicking);
        NBTTagCompound nbt = preview.getTileData().func_74737_b();
        preview.writeToNBT(nbt);
        context.set(nbt);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static List<LittleRenderBox> getItemRenderingCubes(ItemStack stack) {
        ArrayList<LittleRenderBox> cubes = new ArrayList<LittleRenderBox>();
        if (stack != null && stack.func_77942_o()) {
            if (stack.func_77978_p().func_74764_b("size")) {
                Block block = Block.func_149684_b((String)stack.func_77978_p().func_74779_i("block"));
                int meta = stack.func_77978_p().func_74762_e("meta");
                LittleVec size = new LittleVec("size", stack.func_77978_p());
                if (!(block instanceof BlockAir)) {
                    LittleRenderBox cube = new LittleBox(0, 0, 0, size.x, size.y, size.z).getRenderingCube(LittleGridContext.get(), block, meta);
                    if (stack.func_77978_p().func_74764_b("color")) {
                        cube.color = stack.func_77978_p().func_74762_e("color");
                    }
                    cubes.add(cube);
                }
            } else {
                ILittlePlacer iTile = PlacementHelper.getLittleInterface(stack);
                LittlePreview preview = LittleTileRegistry.loadPreview(stack.func_77978_p());
                if (preview.getBlockInfo().contains(":")) {
                    cubes.add((LittleRenderBox)preview.getCubeBlock(iTile.getPreviewsContext(stack)));
                }
            }
        }
        return cubes;
    }

    public List<? extends RenderBox> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        if (stack != null) {
            return ItemBlockTiles.getItemRenderingCubes(stack);
        }
        return new ArrayList();
    }

    @Override
    public PlacementMode getPlacementMode(ItemStack stack) {
        return ItemMultiTiles.currentMode;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUIAdvanced(EntityPlayer player, ItemStack stack) {
        return new SubGuiModeSelector(stack, ItemMultiTiles.currentContext, ItemMultiTiles.currentMode){

            @Override
            public void saveConfiguration(LittleGridContext context, PlacementMode mode) {
                ItemMultiTiles.currentContext = context;
                ItemMultiTiles.currentMode = mode;
            }
        };
    }

    @Override
    public LittleGridContext getPositionContext(ItemStack stack) {
        return ItemMultiTiles.currentContext;
    }

    @Override
    public boolean containsIngredients(ItemStack stack) {
        return true;
    }
}

