/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.DynIntHashMap;

public class FluidStateRenderer
extends CustomRenderer {
    private static final int PATCH_STILL = 0;
    private static final int PATCH_FLOWING = 1;
    private static final int[] still_patches = new int[]{0, 0, 1, 1, 1, 1};
    private static final int[] flow_patches = new int[]{0, 1, 1, 1, 1, 1};
    private static RenderPatch bottom = null;
    private static DynIntHashMap meshcache = new DynIntHashMap();

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        for (int i = 0; i < 10; ++i) {
            list.clear();
            CustomRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0 - (double)i / 9.0, 0.0, 1.0, still_patches);
            FluidStateRenderer.putCachedModel(9 - i, 9 - i, 9 - i, 9 - i, list.toArray(new RenderPatch[list.size()]));
        }
        if (bottom == null) {
            bottom = rpf.getPatch(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, RenderPatchFactory.SideVisible.TOP, 0);
        }
        return true;
    }

    @Override
    public int getMaximumTextureCount() {
        return 2;
    }

    private DynmapBlockState getFluidState(MapDataContext ctx, int dx, int dy, int dz) {
        DynmapBlockState bs = dx == 0 && dy == 0 && dz == 0 ? ctx.getBlockType() : ctx.getBlockTypeAt(dx, dy, dz);
        DynmapBlockState fbs = bs.getLiquidState();
        return fbs != null ? fbs : bs;
    }

    private int getAirHeight(DynmapBlockState bs) {
        int idx = bs.stateIndex;
        return idx > 7 ? 1 : idx + 1;
    }

    private static final int getIntKey(int h_1_1, int h_n1_1, int h_1_n1, int h_n1_n1) {
        return h_1_1 + (h_n1_1 << 4) + (h_1_n1 << 8) + (h_n1_n1 << 12);
    }

    private static RenderPatch[] getCachedModel(int h_1_1, int h_n1_1, int h_1_n1, int h_n1_n1) {
        return (RenderPatch[])meshcache.get(FluidStateRenderer.getIntKey(h_1_1, h_n1_1, h_1_n1, h_n1_n1));
    }

    private static void putCachedModel(int h_1_1, int h_n1_1, int h_1_n1, int h_n1_n1, RenderPatch[] model) {
        meshcache.put(FluidStateRenderer.getIntKey(h_1_1, h_n1_1, h_1_n1, h_n1_n1), model);
    }

    private int getCornerHeight(DynmapBlockState b0, DynmapBlockState b1, DynmapBlockState b2, DynmapBlockState b3, DynmapBlockState u0, DynmapBlockState u1, DynmapBlockState u2, DynmapBlockState u3) {
        if (b0.matchingBaseState(u0) || b0.matchingBaseState(u1) || b0.matchingBaseState(u2) || b0.matchingBaseState(u3)) {
            return 9;
        }
        int accum = 0;
        int cnt = 0;
        int h = this.getAirHeight(b0);
        if (h == 1) {
            accum += 11 * h;
            cnt += 11;
        } else {
            accum += h;
            ++cnt;
        }
        if (b1.matchingBaseState(b0)) {
            h = this.getAirHeight(b1);
            if (h == 1) {
                accum += 11 * h;
                cnt += 11;
            } else {
                accum += h;
                ++cnt;
            }
        } else if (!b1.isSolid()) {
            accum += 9;
            ++cnt;
        }
        if (b2.matchingBaseState(b0)) {
            h = this.getAirHeight(b2);
            if (h == 1) {
                accum += 11 * h;
                cnt += 11;
            } else {
                accum += h;
                ++cnt;
            }
        } else if (!b2.isSolid()) {
            accum += 9;
            ++cnt;
        }
        if (b3.matchingBaseState(b0)) {
            h = this.getAirHeight(b3);
            if (h == 1) {
                accum += 11 * h;
                cnt += 11;
            } else {
                accum += h;
                ++cnt;
            }
        } else if (!b3.isSolid()) {
            accum += 9;
            ++cnt;
        }
        return 9 - (accum + cnt / 2) / cnt;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int bh_n1_n1;
        DynmapBlockState bs_0_0_0 = this.getFluidState(ctx, 0, 0, 0);
        DynmapBlockState bs_0_1_0 = this.getFluidState(ctx, 0, 1, 0);
        if (bs_0_1_0.matchingBaseState(bs_0_0_0)) {
            return FluidStateRenderer.getCachedModel(9, 9, 9, 9);
        }
        DynmapBlockState bs_0_1_1 = this.getFluidState(ctx, 0, 1, 1);
        DynmapBlockState bs_1_1_0 = this.getFluidState(ctx, 1, 1, 0);
        DynmapBlockState bs_1_1_1 = this.getFluidState(ctx, 1, 1, 1);
        DynmapBlockState bs_0_1_n1 = this.getFluidState(ctx, 0, 1, -1);
        DynmapBlockState bs_n1_1_0 = this.getFluidState(ctx, -1, 1, 0);
        DynmapBlockState bs_n1_1_n1 = this.getFluidState(ctx, -1, 1, -1);
        DynmapBlockState bs_1_1_n1 = this.getFluidState(ctx, 1, 1, -1);
        DynmapBlockState bs_n1_1_1 = this.getFluidState(ctx, -1, 1, 1);
        DynmapBlockState bs_0_0_1 = this.getFluidState(ctx, 0, 0, 1);
        DynmapBlockState bs_1_0_0 = this.getFluidState(ctx, 1, 0, 0);
        DynmapBlockState bs_1_0_1 = this.getFluidState(ctx, 1, 0, 1);
        DynmapBlockState bs_0_0_n1 = this.getFluidState(ctx, 0, 0, -1);
        DynmapBlockState bs_n1_0_0 = this.getFluidState(ctx, -1, 0, 0);
        DynmapBlockState bs_n1_0_n1 = this.getFluidState(ctx, -1, 0, -1);
        DynmapBlockState bs_1_0_n1 = this.getFluidState(ctx, 1, 0, -1);
        DynmapBlockState bs_n1_0_1 = this.getFluidState(ctx, -1, 0, 1);
        int bh_1_1 = this.getCornerHeight(bs_0_0_0, bs_0_0_1, bs_1_0_0, bs_1_0_1, bs_0_1_0, bs_1_1_0, bs_0_1_1, bs_1_1_1);
        int bh_1_n1 = this.getCornerHeight(bs_0_0_0, bs_0_0_n1, bs_1_0_0, bs_1_0_n1, bs_0_1_0, bs_1_1_0, bs_0_1_n1, bs_1_1_n1);
        int bh_n1_1 = this.getCornerHeight(bs_0_0_0, bs_0_0_1, bs_n1_0_0, bs_n1_0_1, bs_0_1_0, bs_n1_1_0, bs_0_1_1, bs_n1_1_1);
        RenderPatch[] mod = FluidStateRenderer.getCachedModel(bh_1_1, bh_n1_1, bh_1_n1, bh_n1_n1 = this.getCornerHeight(bs_0_0_0, bs_0_0_n1, bs_n1_0_0, bs_n1_0_n1, bs_0_1_0, bs_n1_1_0, bs_0_1_n1, bs_n1_1_n1));
        if (mod == null) {
            RenderPatchFactory rpf = ctx.getPatchFactory();
            ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
            list.add(bottom);
            this.addSide(list, rpf, 0.0, 0.0, 0.0, 1.0, bh_n1_n1, bh_n1_1);
            this.addSide(list, rpf, 1.0, 1.0, 1.0, 0.0, bh_1_1, bh_1_n1);
            this.addSide(list, rpf, 1.0, 0.0, 0.0, 0.0, bh_1_n1, bh_n1_n1);
            this.addSide(list, rpf, 0.0, 1.0, 1.0, 1.0, bh_n1_1, bh_1_1);
            int edge_xm = bh_n1_n1 + bh_n1_1;
            int edge_xp = bh_1_n1 + bh_1_1;
            int edge_zm = bh_n1_n1 + bh_1_n1;
            int edge_zp = bh_1_1 + bh_n1_1;
            if (edge_xp <= edge_xm && edge_xp <= edge_zm && edge_xp <= edge_zp) {
                this.addTop(list, rpf, 1.0, 1.0, 1.0, 0.0, bh_1_1, bh_1_n1, bh_n1_1, bh_n1_n1);
            } else if (edge_zp <= edge_zm && edge_zp <= edge_xm && edge_zp <= edge_xp) {
                this.addTop(list, rpf, 0.0, 1.0, 1.0, 1.0, bh_n1_1, bh_1_1, bh_n1_n1, bh_1_n1);
            } else if (edge_xm <= edge_xp && edge_xm <= edge_zm && edge_xm <= edge_zp) {
                this.addTop(list, rpf, 0.0, 0.0, 0.0, 1.0, bh_n1_n1, bh_n1_1, bh_1_n1, bh_1_1);
            } else {
                this.addTop(list, rpf, 1.0, 0.0, 0.0, 0.0, bh_1_n1, bh_n1_n1, bh_1_1, bh_n1_1);
            }
            mod = list.toArray(new RenderPatch[list.size()]);
            FluidStateRenderer.putCachedModel(bh_1_1, bh_n1_1, bh_1_n1, bh_n1_n1, mod);
        }
        return mod;
    }

    private void addSide(ArrayList<RenderPatch> list, RenderPatchFactory rpf, double x0, double z0, double x1, double z1, int h0, int h1) {
        if (h0 == 0 && h1 == 0) {
            return;
        }
        list.add(rpf.getPatch(x0, 0.0, z0, x1, 0.0, z1, x0, 1.0, z0, 0.0, 1.0, 0.0, 0.0, (double)h0 / 9.0, (double)h1 / 9.0, RenderPatchFactory.SideVisible.TOP, 1));
    }

    private void addTop(ArrayList<RenderPatch> list, RenderPatchFactory rpf, double x0, double z0, double x1, double z1, int h0, int h1, int h2, int h3) {
        int h0_upper = h1 + h2 - h3;
        if (x0 == x1) {
            if (h0_upper == h0) {
                list.add(rpf.getPatch(x0, (double)h0 / 9.0, z0, x1, (double)h1 / 9.0, z1, 1.0 - x0, (double)h2 / 9.0, z0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 1));
            } else {
                list.add(rpf.getPatch(x0, (double)h0 / 9.0, z0, x1, (double)h1 / 9.0, z1, 1.0 - x0, (double)h2 / 9.0, z0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, RenderPatchFactory.SideVisible.TOP, 1));
                list.add(rpf.getPatch(x0, (double)h0_upper / 9.0, z0, x1, (double)h1 / 9.0, z1, 1.0 - x0, (double)h2 / 9.0, z0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 1));
            }
        } else if (h0_upper == h0) {
            list.add(rpf.getPatch(x0, (double)h0 / 9.0, z0, x1, (double)h1 / 9.0, z1, x0, (double)h2 / 9.0, 1.0 - z0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 1));
        } else {
            list.add(rpf.getPatch(x0, (double)h0 / 9.0, z0, x1, (double)h1 / 9.0, z1, x0, (double)h2 / 9.0, 1.0 - z0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, RenderPatchFactory.SideVisible.TOP, 1));
            list.add(rpf.getPatch(x0, (double)h0_upper / 9.0, z0, x1, (double)h1 / 9.0, z1, x0, (double)h2 / 9.0, 1.0 - z0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, RenderPatchFactory.SideVisible.TOP, 1));
        }
    }
}

