/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.item.upgrade;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.util.InvUtils;
import com.latmod.yabba.api.UpgradeData;
import com.latmod.yabba.item.upgrade.ItemUpgrade;
import com.latmod.yabba.tile.Barrel;
import com.latmod.yabba.tile.ItemBarrel;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemUpgradeHopper
extends ItemUpgrade {
    @Override
    public UpgradeData initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new HopperUpgradeData(stack);
    }

    public static class HopperUpgradeData
    extends UpgradeData {
        public boolean down = true;
        public boolean up = true;
        public boolean collect = false;
        public int progress = 0;

        public HopperUpgradeData(ItemStack is) {
            super(is);
        }

        @Override
        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("Down", this.down);
            nbt.func_74757_a("Up", this.up);
            nbt.func_74757_a("Collect", this.collect);
            nbt.func_74774_a("Progress", (byte)this.progress);
            return nbt;
        }

        @Override
        public void deserializeNBT(NBTTagCompound nbt) {
            this.down = nbt.func_74767_n("Down");
            this.up = nbt.func_74767_n("Up");
            this.collect = nbt.func_74767_n("Collect");
            this.progress = nbt.func_74771_c("Progress");
        }

        @Override
        public void getConfig(Barrel barrel, ConfigGroup config) {
            config.addBool("up", () -> this.up, v -> {
                this.up = v;
            }, true).setDisplayName((ITextComponent)new TextComponentTranslation("barrel_config.hopper.up", new Object[0]));
            config.addBool("down", () -> this.down, v -> {
                this.down = v;
            }, true).setDisplayName((ITextComponent)new TextComponentTranslation("barrel_config.hopper.down", new Object[0]));
            config.addBool("collect", () -> this.collect, v -> {
                this.collect = v;
            }, false).setDisplayName((ITextComponent)new TextComponentTranslation("barrel_config.hopper.collect", new Object[0]));
        }

        @Override
        public boolean hasData() {
            return !this.down || !this.up || this.collect;
        }

        @Override
        public void resetData() {
            this.down = true;
            this.up = true;
            this.collect = false;
        }

        @Override
        public boolean isTicking(World world) {
            return !world.field_72995_K;
        }

        @Override
        public void onTick(Barrel barrel) {
            TileEntity tileEntity = barrel.block.getBarrelTileEntity();
            if (tileEntity == null || !tileEntity.func_145830_o()) {
                return;
            }
            World world = tileEntity.func_145831_w();
            BlockPos pos = tileEntity.func_174877_v();
            ++this.progress;
            if (this.progress > 8) {
                if (barrel.content instanceof ItemBarrel) {
                    TileEntity tileUp;
                    TileEntity tileDown;
                    ItemBarrel itemBarrel = (ItemBarrel)barrel.content;
                    int maxItems = 1 << barrel.getTier().tier;
                    if (itemBarrel.count > 0 && this.down && (tileDown = world.func_175625_s(pos.func_177972_a(EnumFacing.DOWN))) != null && tileDown.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
                        InvUtils.transferItems((IItemHandler)itemBarrel, (IItemHandler)((IItemHandler)tileDown.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)), (int)Math.min(maxItems, itemBarrel.count), (Predicate)InvUtils.NO_FILTER);
                    }
                    if (this.up && (tileUp = world.func_175625_s(pos.func_177972_a(EnumFacing.UP))) != null && tileUp.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
                        InvUtils.transferItems((IItemHandler)((IItemHandler)tileUp.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)), (IItemHandler)itemBarrel, (int)Math.min(maxItems, itemBarrel.getFreeSpace()), (Predicate)InvUtils.NO_FILTER);
                    }
                    if (this.collect) {
                        AxisAlignedBB aabb = new AxisAlignedBB(pos.func_177982_a(0, 1, 0), pos.func_177982_a(1, 2, 1));
                        for (EntityItem item : world.func_175647_a(EntityItem.class, aabb, null)) {
                            ItemStack stack = itemBarrel.insertItem(0, item.func_92059_d().func_77946_l(), false);
                            if (stack.func_190926_b()) {
                                item.func_70106_y();
                                continue;
                            }
                            item.func_92058_a(stack);
                        }
                    }
                }
                this.progress = 0;
            }
        }
    }
}

