/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.generic.ai;

import com.animania.api.interfaces.IPlaying;
import com.animania.api.interfaces.ISleeping;
import com.animania.common.helper.AnimaniaHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.math.Vec3d;

public class GenericAIPlay<T extends EntityCreature & IPlaying, U extends EntityCreature & IPlaying>
extends EntityAIBase {
    private T entity;
    private Class<? extends U> playmateClass;
    private Path path = null;
    private PathNavigate navigator;
    public boolean isRunning = false;
    public boolean isChaser = false;
    public U playmate = null;
    private static final Random rand = new Random();

    public GenericAIPlay(T entity, Class<? extends U> playmateType) {
        this.entity = entity;
        this.playmateClass = playmateType;
        this.navigator = entity.func_70661_as();
    }

    public boolean func_75250_a() {
        if (this.isRunning) {
            return true;
        }
        if (((ISleeping)this.entity).getSleeping()) {
            return false;
        }
        List<EntityCreature> list = AnimaniaHelper.getEntitiesInRangeWithPredicate(this.playmateClass, 5.0, ((EntityCreature)this.entity).field_70170_p, this.entity, e -> !((ISleeping)e).getSleeping() && !((IPlaying)e).getPlayAI().isRunning);
        if (list.isEmpty()) {
            return false;
        }
        return rand.nextDouble() < 0.2;
    }

    public boolean func_75253_b() {
        if (rand.nextDouble() < 0.1) {
            return false;
        }
        if (!this.func_75250_a()) {
            return false;
        }
        return super.func_75253_b();
    }

    public void func_75251_c() {
        this.isRunning = false;
        this.isChaser = false;
        this.playmate = null;
        this.path = null;
    }

    public void func_75249_e() {
        List<EntityCreature> list;
        if (!this.isRunning && !(list = AnimaniaHelper.getEntitiesInRangeWithPredicate(this.playmateClass, 5.0, ((EntityCreature)this.entity).field_70170_p, this.entity, e -> !((ISleeping)e).getSleeping() && !((IPlaying)e).getPlayAI().isRunning)).isEmpty()) {
            this.playmate = list.get(0);
            this.isRunning = true;
            this.isChaser = true;
            GenericAIPlay otherAI = ((IPlaying)this.playmate).getPlayAI();
            otherAI.playmate = this.entity;
            otherAI.isRunning = true;
            otherAI.isChaser = false;
        }
    }

    public void func_75246_d() {
        if (this.isRunning) {
            if (this.isChaser) {
                if (this.path == null || this.navigator.func_75500_f()) {
                    this.path = this.navigator.func_75494_a(this.playmate);
                }
                this.navigator.func_75484_a(this.path, 1.0);
                if ((double)this.entity.func_70032_d(this.playmate) <= 0.5) {
                    GenericAIPlay otherAI = ((IPlaying)this.playmate).getPlayAI();
                    otherAI.isChaser = true;
                    this.isChaser = false;
                }
            } else {
                Vec3d vec3d;
                if ((this.path == null || this.navigator.func_75500_f()) && (vec3d = RandomPositionGenerator.func_75461_b(this.entity, (int)16, (int)7, (Vec3d)new Vec3d(((EntityCreature)this.playmate).field_70165_t, ((EntityCreature)this.playmate).field_70163_u, ((EntityCreature)this.playmate).field_70161_v))) != null) {
                    this.path = this.navigator.func_75488_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                }
                this.navigator.func_75484_a(this.path, 1.0);
            }
        }
    }
}

