/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting.factories;

import com.google.gson.JsonObject;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xreliquary.init.ModItems;
import xreliquary.init.XRRecipes;
import xreliquary.items.ItemAlkahestryTome;
import xreliquary.reference.Settings;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AlkahestryDrainRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        int chargeToDrain = JsonUtils.func_151203_m((JsonObject)json, (String)"charge");
        ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
        return new AlkahestryDrainRecipe(new ResourceLocation("xreliquary", "alkahestry_drain"), chargeToDrain, result);
    }

    public static class AlkahestryDrainRecipe
    extends IForgeRegistryEntry.Impl<IRecipe>
    implements IRecipe {
        private final int chargeToDrain;
        private final ItemStack result;
        private final NonNullList<Ingredient> input;
        private ResourceLocation group;

        public AlkahestryDrainRecipe(ResourceLocation group, int chargeToDrain, ItemStack result) {
            this.group = group;
            ItemStack tome = new ItemStack((Item)ModItems.alkahestryTome);
            ItemAlkahestryTome.setCharge(tome, Settings.Items.AlkahestryTome.chargeLimit);
            this.input = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{tome})});
            this.chargeToDrain = chargeToDrain;
            this.result = result;
            XRRecipes.drainRecipe = this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            boolean hasTome = false;
            ItemStack tome = ItemStack.field_190927_a;
            for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                ItemStack stack = inv.func_70301_a(slot);
                if (stack.func_190926_b()) continue;
                if (hasTome) return false;
                if (stack.func_77973_b() != ModItems.alkahestryTome) return false;
                hasTome = true;
                tome = stack;
            }
            if (!hasTome) return false;
            if (ItemAlkahestryTome.getCharge(tome) <= 0) return false;
            return true;
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            ItemStack tome = this.getTome(inv).func_77946_l();
            int charge = ItemAlkahestryTome.getCharge(tome);
            ItemStack ret = this.result.func_77946_l();
            ret.func_190920_e(Math.min(ret.func_77976_d(), charge / this.chargeToDrain));
            return ret;
        }

        public boolean func_194133_a(int width, int height) {
            return width * height >= 1;
        }

        public ItemStack func_77571_b() {
            return this.result;
        }

        private ItemStack getTome(InventoryCrafting inv) {
            for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                ItemStack stack = inv.func_70301_a(slot);
                if (stack.func_77973_b() != ModItems.alkahestryTome) continue;
                return stack;
            }
            return ItemStack.field_190927_a;
        }

        public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
            NonNullList ret = super.func_179532_b(inv);
            for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                ItemStack stack = inv.func_70301_a(slot);
                if (stack.func_77973_b() != ModItems.alkahestryTome) continue;
                ItemStack tome = stack.func_77946_l();
                int charge = ItemAlkahestryTome.getCharge(tome);
                int itemCount = Math.min(this.result.func_77976_d(), charge / this.chargeToDrain);
                ModItems.alkahestryTome.useCharge(tome, itemCount * this.chargeToDrain);
                ret.set(slot, (Object)tome);
            }
            return ret;
        }

        public NonNullList<Ingredient> func_192400_c() {
            return this.input;
        }

        public String func_193358_e() {
            return this.group.toString();
        }
    }
}

