/*
 * Decompiled with CFR 0.152.
 */
package openmods.model.itemstate;

import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import openmods.model.itemstate.ISimpleStateItem;
import openmods.state.State;
import openmods.state.StateContainer;

public class SimpleStateItemSetup {
    public static <T extends Item> void setupItemRendering(T item) {
        SimpleStateItemSetup.setupItemRendering(item.getRegistryName(), item);
    }

    public static <T extends Item> void setupItemRendering(ResourceLocation base, T item) {
        ResourceLocation id = item.getRegistryName();
        StateContainer stateContainer = ((ISimpleStateItem)item).getStateContainer();
        for (State state : stateContainer.getAllStates()) {
            ModelResourceLocation modelLoc = new ModelResourceLocation(id, state.getVariant());
            ModelBakery.registerItemVariants(item, (ResourceLocation[])new ResourceLocation[]{modelLoc});
        }
        ModelLoader.setCustomMeshDefinition(item, stack -> {
            State state = ((ISimpleStateItem)item).getState(stack);
            return new ModelResourceLocation(id, state.getVariant());
        });
    }
}

