/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.behaviour;

import buildcraft.api.BCModules;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.lib.misc.AdvancementUtil;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import buildcraft.transport.BCTransportGuis;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class PipeBehaviourDiamond
extends PipeBehaviour {
    public static final int FILTERS_PER_SIDE = 9;
    public static final ResourceLocation ADVANCEMENT_NEED_LIST = BCModules.TRANSPORT.createLocation("too_many_pipe_filters");
    public final ItemHandlerSimple filters = new ItemHandlerSimple(54, this::onFilterSlotChange);

    public PipeBehaviourDiamond(IPipe pipe) {
        super(pipe);
    }

    public PipeBehaviourDiamond(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.filters.deserializeNBT(nbt.func_74775_l("filters"));
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74782_a("filters", (NBTBase)this.filters.serializeNBT());
        return nbt;
    }

    protected void onFilterSlotChange(IItemHandlerModifiable itemHandler, int slot, ItemStack before, ItemStack after) {
        if (this.pipe.getHolder().getPipeWorld().field_72995_K) {
            return;
        }
        int baseIndex = 9 * (slot / 9);
        int count = 0;
        for (int i = 0; i < 9; ++i) {
            int idx = i + baseIndex;
            if (this.filters.getStackInSlot(idx).func_190926_b()) continue;
            ++count;
        }
        if (count >= 7) {
            AdvancementUtil.unlockAdvancement(this.pipe.getHolder().getOwner().getId(), ADVANCEMENT_NEED_LIST);
        }
    }

    @Override
    public int getTextureIndex(EnumFacing face) {
        return face == null ? 0 : face.ordinal() + 1;
    }

    @Override
    public boolean onPipeActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ, EnumPipePart part) {
        if (!player.field_70170_p.field_72995_K) {
            BCTransportGuis.PIPE_DIAMOND.openGui(player, this.pipe.getHolder().getPipePos());
        }
        return true;
    }
}

