/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.manager;

import com.google.common.collect.Sets;
import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.command.Command;
import io.github.lxgaming.sledgehammer.command.DebugCommand;
import io.github.lxgaming.sledgehammer.command.HelpCommand;
import io.github.lxgaming.sledgehammer.command.InformationCommand;
import io.github.lxgaming.sledgehammer.command.ReloadCommand;
import io.github.lxgaming.sledgehammer.util.Locale;
import io.github.lxgaming.sledgehammer.util.StringUtils;
import io.github.lxgaming.sledgehammer.util.Toolbox;
import io.github.lxgaming.sledgehammer.util.text.adapter.LocaleAdapter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.command.ICommandSender;

public final class CommandManager {
    public static final Set<Command> COMMANDS = Sets.newLinkedHashSet();
    private static final Set<Class<? extends Command>> COMMAND_CLASSES = Sets.newHashSet();

    public static void prepare() {
        CommandManager.registerCommand(DebugCommand.class);
        CommandManager.registerCommand(HelpCommand.class);
        CommandManager.registerCommand(InformationCommand.class);
        CommandManager.registerCommand(ReloadCommand.class);
    }

    public static boolean execute(ICommandSender commandSender, List<String> arguments) {
        String content = String.join((CharSequence)" ", arguments);
        if (arguments.isEmpty() || StringUtils.isBlank((CharSequence)content)) {
            LocaleAdapter.sendFeedback(commandSender, Locale.COMMAND_BASE, "sledgehammer");
            return false;
        }
        Command command = CommandManager.getCommand(arguments);
        if (command == null) {
            LocaleAdapter.sendFeedback(commandSender, Locale.COMMAND_NOT_FOUND, new Object[0]);
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)command.getPermission()) && !commandSender.func_70003_b(4, command.getPermission())) {
            LocaleAdapter.sendFeedback(commandSender, Locale.COMMAND_NO_PERMISSION, new Object[0]);
            return false;
        }
        Sledgehammer.getInstance().debug("Processing {} for {}", content, commandSender.func_70005_c_());
        try {
            command.execute(commandSender, arguments);
            return true;
        }
        catch (Exception ex) {
            Sledgehammer.getInstance().getLogger().error("Encountered an error while executing {}", (Object)Toolbox.getClassSimpleName(command.getClass()), (Object)ex);
            LocaleAdapter.sendFeedback(commandSender, Locale.COMMAND_EXCEPTION, new Object[0]);
            return false;
        }
    }

    public static boolean registerAlias(Command command, String alias) {
        if (StringUtils.containsIgnoreCase(command.getAliases(), alias)) {
            Sledgehammer.getInstance().getLogger().warn("{} is already registered for {}", (Object)alias, (Object)Toolbox.getClassSimpleName(command.getClass()));
            return false;
        }
        command.getAliases().add(alias);
        Sledgehammer.getInstance().getLogger().debug("{} registered for {}", (Object)alias, (Object)Toolbox.getClassSimpleName(command.getClass()));
        return true;
    }

    public static boolean registerCommand(Class<? extends Command> commandClass) {
        Command command = CommandManager.registerCommand(COMMANDS, commandClass);
        if (command != null) {
            Sledgehammer.getInstance().getLogger().debug("{} registered", (Object)Toolbox.getClassSimpleName(commandClass));
            return true;
        }
        return false;
    }

    public static boolean registerCommand(Command parentCommand, Class<? extends Command> commandClass) {
        if (parentCommand.getClass() == commandClass) {
            Sledgehammer.getInstance().getLogger().warn("{} attempted to register itself", (Object)Toolbox.getClassSimpleName(parentCommand.getClass()));
            return false;
        }
        Command command = CommandManager.registerCommand(parentCommand.getChildren(), commandClass);
        if (command != null) {
            Sledgehammer.getInstance().getLogger().debug("{} registered for {}", (Object)Toolbox.getClassSimpleName(commandClass), (Object)Toolbox.getClassSimpleName(parentCommand.getClass()));
            return true;
        }
        return false;
    }

    private static Command registerCommand(Set<Command> commands, Class<? extends Command> commandClass) {
        if (COMMAND_CLASSES.contains(commandClass)) {
            Sledgehammer.getInstance().getLogger().warn("{} is already registered", (Object)Toolbox.getClassSimpleName(commandClass));
            return null;
        }
        COMMAND_CLASSES.add(commandClass);
        Command command = Toolbox.newInstance(commandClass);
        if (command == null) {
            Sledgehammer.getInstance().getLogger().error("{} failed to initialize", (Object)Toolbox.getClassSimpleName(commandClass));
            return null;
        }
        if (!command.prepare()) {
            Sledgehammer.getInstance().getLogger().warn("{} failed to prepare", (Object)Toolbox.getClassSimpleName(commandClass));
            return null;
        }
        if (commands.add(command)) {
            return command;
        }
        return null;
    }

    public static Command getCommand(Class<? extends Command> commandClass) {
        return CommandManager.getCommand(null, commandClass);
    }

    public static Command getCommand(Command parentCommand, Class<? extends Command> commandClass) {
        LinkedHashSet commands = Sets.newLinkedHashSet();
        if (parentCommand != null) {
            commands.addAll(parentCommand.getChildren());
        } else {
            commands.addAll(COMMANDS);
        }
        for (Command command : commands) {
            if (command.getClass() == commandClass) {
                return command;
            }
            Command childCommand = CommandManager.getCommand(command, commandClass);
            if (childCommand == null) continue;
            return childCommand;
        }
        return null;
    }

    public static Command getCommand(List<String> arguments) {
        return CommandManager.getCommand(null, arguments);
    }

    private static Command getCommand(Command parentCommand, List<String> arguments) {
        if (arguments.isEmpty()) {
            return parentCommand;
        }
        LinkedHashSet commands = Sets.newLinkedHashSet();
        if (parentCommand != null) {
            commands.addAll(parentCommand.getChildren());
        } else {
            commands.addAll(COMMANDS);
        }
        for (Command command : commands) {
            if (!StringUtils.containsIgnoreCase(command.getAliases(), arguments.get(0))) continue;
            arguments.remove(0);
            return CommandManager.getCommand(command, arguments);
        }
        return parentCommand;
    }
}

