/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.entities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.silvercatcher.reforged.api.AReforgedThrowable;
import org.silvercatcher.reforged.api.CompoundTags;
import org.silvercatcher.reforged.items.weapons.ItemBoomerang;
import org.silvercatcher.reforged.material.MaterialDefinition;
import org.silvercatcher.reforged.util.Helpers;

public class EntityBoomerang
extends AReforgedThrowable {
    public static final DataParameter<Float> THROWER_X = EntityDataManager.func_187226_a(EntityBoomerang.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Float> THROWER_Y = EntityDataManager.func_187226_a(EntityBoomerang.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Float> THROWER_Z = EntityDataManager.func_187226_a(EntityBoomerang.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Float> YAW = EntityDataManager.func_187226_a(EntityBoomerang.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<ItemStack> STACK = EntityDataManager.func_187226_a(EntityBoomerang.class, (DataSerializer)DataSerializers.field_187196_f);

    public EntityBoomerang(World worldIn) {
        super(worldIn, "boomerang");
    }

    public EntityBoomerang(World worldIn, EntityLivingBase thrower, ItemStack stack) {
        super(worldIn, thrower, "boomerang");
        this.setItemStack(stack);
        this.setCoords(thrower.field_70165_t, thrower.field_70163_u + (double)thrower.func_70047_e(), thrower.field_70161_v);
        this.setInited();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STACK, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(YAW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(THROWER_X, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(THROWER_Y, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(THROWER_Z, (Object)Float.valueOf(0.0f));
        this.field_70177_z = ((Float)this.field_70180_af.func_187225_a(YAW)).floatValue();
    }

    @Override
    protected float func_70185_h() {
        return 0.0f;
    }

    @Override
    protected float getImpactDamage(Entity target) {
        return this.getMaterialDefinition().getDamageVsEntity() + 5.0f;
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(STACK);
    }

    public MaterialDefinition getMaterialDefinition() {
        MaterialDefinition md;
        try {
            md = ((ItemBoomerang)this.getItemStack().func_77973_b()).getMaterialDefinition();
        }
        catch (ClassCastException | NullPointerException e) {
            md = null;
        }
        return md;
    }

    public double getPosX() {
        return ((Float)this.field_70180_af.func_187225_a(THROWER_X)).floatValue();
    }

    public double getPosY() {
        return ((Float)this.field_70180_af.func_187225_a(THROWER_Y)).floatValue();
    }

    public double getPosZ() {
        return ((Float)this.field_70180_af.func_187225_a(THROWER_Z)).floatValue();
    }

    @Override
    protected boolean onBlockHit(BlockPos blockPos) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getItemStack().func_77958_k() - this.getItemStack().func_77952_i() > 0 && !this.creativeUse()) {
                this.func_70099_a(this.getItemStack(), 0.5f);
                Helpers.playSound(this.field_70170_p, (Entity)this, "boomerang_hit", 2.0f, 1.0f);
            } else if (this.getItemStack().func_77958_k() - this.getItemStack().func_77952_i() <= 0) {
                Helpers.playSound(this.field_70170_p, (Entity)this, "boomerang_break", 2.0f, 1.0f);
            } else if (this.creativeUse()) {
                Helpers.playSound(this.field_70170_p, (Entity)this, "boomerang_hit", 2.0f, 1.0f);
            }
        }
        return true;
    }

    @Override
    protected boolean onEntityHit(Entity hitEntity) {
        if (hitEntity == this.func_85052_h()) {
            ItemStack stack = this.getItemStack();
            EntityPlayer p = (EntityPlayer)hitEntity;
            if (stack.func_77958_k() - stack.func_77952_i() > 0 && !this.creativeUse()) {
                p.field_71071_by.func_70441_a(stack);
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.MASTER, 0.5f, 0.7f);
            } else if (this.getItemStack().func_77958_k() - this.getItemStack().func_77952_i() <= 0) {
                Helpers.playSound(this.field_70170_p, (Entity)this, "boomerang_break", 1.0f, 1.0f);
            }
            return true;
        }
        hitEntity.func_70097_a(this.causeImpactDamage(hitEntity, this.func_85052_h()), this.getImpactDamage(hitEntity));
        ItemStack stack = this.getItemStack();
        if (stack.func_77973_b().func_77645_m() && stack.func_96631_a(1, this.field_70146_Z, null)) {
            Helpers.playSound(this.field_70170_p, (Entity)this, "boomerang_break", 1.0f, 1.0f);
            return true;
        }
        this.setItemStack(stack);
        return false;
    }

    @Override
    public void onUpdated() {
        if (this.func_85052_h() != null && CompoundTags.giveCompound(this.getItemStack()).func_74767_n("enchanted")) {
            this.setCoords(this.func_85052_h().field_70165_t, this.func_85052_h().field_70163_u + (double)this.func_85052_h().func_70047_e(), this.func_85052_h().field_70161_v);
        }
        double dx = this.field_70165_t - this.getPosX();
        double dy = this.field_70163_u - this.getPosY();
        double dz = this.field_70161_v - this.getPosZ();
        double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
        this.field_70159_w -= 0.05 * (dx /= d);
        this.field_70181_x -= 0.05 * (dy /= d);
        this.field_70179_y -= 0.05 * (dz /= d);
        if (this.func_70090_H() && !this.field_70170_p.field_72995_K) {
            if (this.getItemStack().func_77958_k() - this.getItemStack().func_77952_i() > 0 && !this.creativeUse()) {
                this.func_70099_a(this.getItemStack(), 0.5f);
            } else if (this.getItemStack().func_77958_k() - this.getItemStack().func_77952_i() <= 0) {
                Helpers.playSound(this.field_70170_p, (Entity)this, "boomerang_break", 1.0f, 1.0f);
            }
            this.func_70106_y();
        }
        if (this.field_70173_aa >= 103) {
            if (CompoundTags.giveCompound(this.getItemStack()).func_74767_n("enchanted")) {
                if (this.onEntityHit(this.func_85052_h())) {
                    this.func_70106_y();
                }
            } else if (!this.field_70170_p.field_72995_K) {
                if (this.getItemStack().func_77958_k() - this.getItemStack().func_77952_i() > 0 && !this.creativeUse()) {
                    this.func_70099_a(this.getItemStack(), 0.5f);
                } else if (this.getItemStack().func_77958_k() - this.getItemStack().func_77952_i() <= 0) {
                    Helpers.playSound(this.field_70170_p, (Entity)this, "boomerang_break", 1.0f, 1.0f);
                }
                this.func_70106_y();
            }
        }
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        this.field_70177_z += 20.0f;
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setItemStack(new ItemStack(tagCompund.func_74775_l("item")));
        this.setCoords(tagCompund.func_74769_h("playerX"), tagCompund.func_74769_h("playerY"), tagCompund.func_74769_h("playerZ"));
        this.field_70180_af.func_187227_b(YAW, (Object)Float.valueOf(tagCompund.func_74760_g("yawreforged")));
    }

    public void setCoords(double playerX, double playerY, double playerZ) {
        this.field_70180_af.func_187227_b(THROWER_X, (Object)Float.valueOf((float)playerX));
        this.field_70180_af.func_187227_b(THROWER_Y, (Object)Float.valueOf((float)playerY));
        this.field_70180_af.func_187227_b(THROWER_Z, (Object)Float.valueOf((float)playerZ));
    }

    public void setItemStack(ItemStack stack) {
        if (stack == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBoomerang)) {
            throw new IllegalArgumentException("Invalid Itemstack!");
        }
        this.field_70180_af.func_187227_b(STACK, (Object)stack);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74780_a("playerX", this.getPosX());
        tagCompound.func_74780_a("playerY", this.getPosY());
        tagCompound.func_74780_a("playerZ", this.getPosZ());
        tagCompound.func_74780_a("yawreforged", (double)((Float)this.field_70180_af.func_187225_a(YAW)).floatValue());
        if (this.getItemStack() != null && !this.getItemStack().func_190926_b()) {
            tagCompound.func_74782_a("item", (NBTBase)this.getItemStack().func_77955_b(new NBTTagCompound()));
        }
    }
}

