/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.electric;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.item.armor.base.ItemArmorElectricJetpackBase;
import ic2.core.item.armor.base.ItemArmorJetpackBase;
import ic2.core.item.armor.electric.ItemArmorQuantumSuit;
import ic2.core.item.inv.inventories.NuclearJetpackInventory;
import ic2.core.item.inv.logics.NuclearJetpackLogic;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArmorQuantumNuclearJetplate
extends ItemArmorQuantumSuit
implements IHandHeldInventory,
ItemArmorJetpackBase.IIndirectJetpack {
    public NuclearQuantumJetpack jetpack = new NuclearQuantumJetpack((Item)this);

    public ItemArmorQuantumNuclearJetplate() {
        super(44, EntityEquipmentSlot.CHEST);
        this.setTranslationKey(Ic2ItemLang.quantumNuclearJetplate);
        this.maxCharge = 2500000;
        this.transferLimit = 0;
    }

    @Override
    public String getTexture() {
        return "ic2:textures/models/armor/quantumjetpack";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        this.jetpack.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        this.jetpack.onArmorTick(world, player, stack);
        this.jetpack.onReactorTick(world, player, stack);
    }

    @Override
    public IHasGui getInventory(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return new NuclearJetpackInventory(player, this, stack);
    }

    @Override
    public int getGuiId(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74764_b("GuiID")) {
            return nbt.func_74762_e("GuiID");
        }
        return -1;
    }

    @Override
    public void setGuiID(ItemStack stack, int id) {
        if (id == -1) {
            StackUtil.getOrCreateNbtData(stack).func_82580_o("GuiID");
            return;
        }
        StackUtil.getOrCreateNbtData(stack).func_74768_a("GuiID", id);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!playerIn.func_70093_af()) {
            if (IC2.platform.isSimulating()) {
                IC2.platform.launchGui(playerIn, this.getInventory(playerIn, hand, playerIn.func_184586_b(hand)), hand);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
        }
        return super.func_77659_a(worldIn, playerIn, hand);
    }

    @Override
    public void useEnergy(ItemStack stack, double amount, EntityLivingBase player) {
        ElectricItem.manager.discharge(stack, amount, Integer.MAX_VALUE, true, false, false);
    }

    @Override
    public boolean canUseEnergy(ItemStack stack, double amount) {
        return ElectricItem.manager.getCharge(stack) >= amount;
    }

    @Override
    public ItemArmorJetpackBase getJetpack() {
        return this.jetpack;
    }

    public static class NuclearQuantumJetpack
    extends ItemArmorElectricJetpackBase {
        Item item;

        public NuclearQuantumJetpack(Item owner) {
            super(-1, EntityEquipmentSlot.CHEST);
            this.item = owner;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
            super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
            List<String> altTip = sortedTooltip.get((Object)ToolTipType.Alt);
            NBTTagCompound nbt = StackUtil.getNbtData(stack);
            altTip.add(Ic2InfoLang.jetpackNuclearHeat.getLocalizedFormatted(nbt.func_74762_e("Heat"), nbt.func_74762_e("MaxHeat")));
            altTip.add(Ic2InfoLang.jetpackNuclearCompHeat.getLocalizedFormatted(100 - nbt.func_74762_e("ComponentHeat") + "%"));
        }

        @Override
        public boolean canDisable(ItemStack stack) {
            return true;
        }

        @Override
        public boolean canProvideEnergy(ItemStack stack) {
            return false;
        }

        @Override
        public double getMaxCharge(ItemStack stack) {
            return ElectricItem.manager.getMaxCharge(stack);
        }

        @Override
        public int getTier(ItemStack stack) {
            return ElectricItem.manager.getTier(stack);
        }

        @Override
        public double getTransferLimit(ItemStack stack) {
            return 0.0;
        }

        @Override
        public boolean canDoRocketMode(ItemStack stack) {
            return true;
        }

        @Override
        public boolean canDoAdvHoverMode(ItemStack stack) {
            return true;
        }

        @Override
        public boolean isElectricJetpack(ItemStack stack) {
            return true;
        }

        @Override
        public float getPower(ItemStack stack) {
            return 2.5f;
        }

        @Override
        public float getThruster(ItemStack stack, ItemArmorJetpackBase.HoverMode mode) {
            switch (mode) {
                case Adv: {
                    return 3.5f;
                }
                case Basic: {
                    return 2.5f;
                }
                case None: {
                    return 1.5f;
                }
            }
            return 2.5f;
        }

        @Override
        public float getDropPercentage(ItemStack stack) {
            return 0.05f;
        }

        @Override
        public int getMaxHeight(ItemStack stack, int worldHeight) {
            return worldHeight;
        }

        @Override
        public int getMaxRocketCharge(ItemStack stack) {
            return 30000;
        }

        @Override
        public int getFuelCost(ItemStack stack, ItemArmorJetpackBase.HoverMode mode) {
            switch (mode) {
                case None: {
                    return 30;
                }
                case Basic: {
                    return 27;
                }
                case Adv: {
                    return 30;
                }
            }
            return 27;
        }

        @Override
        public void useEnergy(EntityPlayer player, ItemStack stack, int amount) {
            ElectricItem.manager.discharge(stack, amount, Integer.MAX_VALUE, true, false, false);
        }

        @Override
        public String getTexture() {
            return "";
        }

        @Override
        public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
            super.onArmorTick(world, player, stack);
            if (IC2.platform.isRendering()) {
                return;
            }
        }

        public void onReactorTick(World world, EntityPlayer player, ItemStack stack) {
            NuclearJetpackLogic logic = this.getLogic(player, stack);
            logic.onTick(stack);
            logic.save(stack);
        }

        public NuclearJetpackLogic getLogic(EntityPlayer player, ItemStack stack) {
            return new NuclearJetpackLogic(stack, player, this.field_77881_a);
        }
    }
}

