/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring.tile;

import ic2.core.block.base.tile.TileEntityChargePadBase;
import ic2.core.item.reactor.base.ItemUraniumRodBase;
import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.util.helpers.ToolHelper;
import ic2.core.util.misc.StackUtil;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityChargePadNuclear
extends TileEntityChargePadBase {
    public int nuclearTicks = 0;
    public int energyProduct = 0;

    public TileEntityChargePadNuclear() {
        super(TileEntityChargePadBase.ChargePadType.Nuclear);
    }

    @Override
    protected double getFieldHeight() {
        return 0.5;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected int getMaxParticalAge() {
        return 14;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected float[] getParticalColour(Random rand) {
        float red = 0.9804688f;
        float green = 0.835938f;
        float blue = 0.1367188f;
        if (this.installedUpgrades[TileEntityChargePadBase.PadUpgrade.Drain.ordinal()]) {
            green /= 2.0f;
            blue /= 2.0f;
        }
        if (this.installedUpgrades[TileEntityChargePadBase.PadUpgrade.Damage.ordinal()]) {
            blue = 0.4f;
            green = 0.4f;
        } else {
            red *= 0.6f + rand.nextFloat() * 0.4f;
        }
        return new float[]{red, green *= 0.6f + rand.nextFloat() * 0.4f, blue *= 0.6f + rand.nextFloat() * 0.4f};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected double[] getParticleVelocity(Random rand) {
        return new double[]{0.0, 7.6, 0.0};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected int getParticalAmount(Random rand) {
        return 6;
    }

    @Override
    public void provideEnergy() {
        int needed;
        super.provideEnergy();
        if (this.nuclearTicks > 0) {
            --this.nuclearTicks;
        }
        if ((needed = this.maxEnergy - this.storedEnergy) > 0) {
            if (this.nuclearTicks == 0) {
                ItemStack stack = this.inv.getStackInSlot(0);
                if (!this.useCell(stack)) {
                    return;
                }
                this.nuclearTicks = 20;
                this.energyProduct = this.getEnergy(stack);
            }
            this.storedEnergy += this.energyProduct;
            this.getNetwork().updateTileGuiField(this, "storedEnergy");
        }
    }

    public int getEnergy(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemUraniumRodBase)) {
            return 0;
        }
        ItemUraniumRodBase rod = (ItemUraniumRodBase)stack.func_77973_b();
        int count = rod.getRodAmount(stack);
        switch (count) {
            case 1: {
                return 5;
            }
            case 2: {
                return 20;
            }
            case 4: {
                return 60;
            }
        }
        return 0;
    }

    private boolean useCell(ItemStack stack) {
        if (!this.isCell(stack)) {
            return false;
        }
        if (ToolHelper.damageItem(stack, 1, null)) {
            this.inv.setStackInSlot(0, this.createUsedCells(stack));
        }
        return true;
    }

    private ItemStack createUsedCells(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemUraniumRodBase)) {
            return ItemStack.field_190927_a;
        }
        if (this.field_145850_b.field_73012_v.nextInt(3) == 0) {
            ItemUraniumRodBase rod = (ItemUraniumRodBase)stack.func_77973_b();
            IUranium uran = rod.getUranium(stack);
            int count = rod.getRodAmount(stack);
            return StackUtil.copyWithSize(uran.getRodType(IUranium.RodType.NearDepletedRod), count);
        }
        return ItemStack.field_190927_a;
    }

    private boolean isCell(ItemStack stack) {
        return !(stack.func_77973_b() instanceof ItemUraniumRodBase);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.nuclearTicks = nbt.func_74762_e("NuclearTicks");
        this.energyProduct = nbt.func_74762_e("NuclearProduction");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("NuclearTicks", this.nuclearTicks);
        nbt.func_74768_a("NuclearProduction", this.energyProduct);
        return nbt;
    }
}

