/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.recipes.managers;

import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.MachineExpOutput;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.MachineRecipe;
import ic2.api.recipe.MachineRecipeResult;
import ic2.core.IC2;
import ic2.core.block.machine.recipes.managers.BasicMachineRecipeList;
import ic2.core.item.recipe.entry.RecipeInputIgnoreNBT;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricFurnaceRecipeList
extends BasicMachineRecipeList {
    boolean init = false;
    boolean autoAddToVanilla = IC2.config.getFlag("enableFurnaceRecipeVanillaShare");

    public ElectricFurnaceRecipeList() {
        super("furnace");
    }

    @Override
    public void addRecipe(IRecipeInput input, MachineOutput output, String id) {
        super.addRecipe(input, output, id);
        if (this.autoAddToVanilla) {
            assert (input != null && input.getInputs().size() == 1);
            assert (output != null && output.getAllOutputs().size() == 1);
            FurnaceRecipes.func_77602_a().func_151394_a(input.getInputs().get(0), output.getAllOutputs().get(0), output.getExperienceOutput());
        }
    }

    @Override
    protected boolean checksRecipes() {
        return false;
    }

    @Override
    public IMachineRecipeList.RecipeEntry getRecipeInAndOutput(ItemStack input, boolean ignore) {
        if (!this.init) {
            this.init = true;
            this.init();
        }
        return super.getRecipeInAndOutput(input, ignore);
    }

    @Override
    public List<IMachineRecipeList.RecipeEntry> getRecipeMap() {
        if (!this.init) {
            this.init = true;
            this.init();
        }
        return super.getRecipeMap();
    }

    @Override
    public List<IMachineRecipeList.RecipeEntry> removeRecipe(IRecipeInput input) {
        if (!this.init) {
            this.init = true;
            this.init();
        }
        return super.removeRecipe(input);
    }

    @Override
    public IMachineRecipeList.RecipeEntry removeRecipe(ItemStack stack) {
        if (!this.init) {
            this.init = true;
            this.init();
        }
        return super.removeRecipe(stack);
    }

    @Override
    public void removeRecipe(IMachineRecipeList.RecipeEntry entry) {
        if (!this.init) {
            this.init = true;
            this.init();
        }
        super.removeRecipe(entry);
    }

    protected void init() {
        FurnaceRecipes list = FurnaceRecipes.func_77602_a();
        for (Map.Entry entry : list.func_77599_b().entrySet()) {
            if (((ItemStack)entry.getKey()).func_190926_b() || ((ItemStack)entry.getValue()).func_190926_b()) continue;
            super.addRecipe((IRecipeInput)new RecipeInputIgnoreNBT((ItemStack)entry.getKey()), new MachineExpOutput(null, list.func_151398_b((ItemStack)entry.getValue()), (ItemStack)entry.getValue()), "Furance");
        }
    }

    @Override
    public IMachineRecipeManager<ItemStack, ItemStack, ItemStack> toIC2Exp() {
        return new IMachineRecipeManager<ItemStack, ItemStack, ItemStack>(){

            @Override
            public boolean addRecipe(ItemStack input, ItemStack output, NBTTagCompound metadata, boolean replace) {
                ElectricFurnaceRecipeList.this.addRecipe((IRecipeInput)new RecipeInputItemStack(input), output, "Furance");
                return true;
            }

            @Override
            public MachineRecipeResult<ItemStack, ItemStack, ItemStack> apply(ItemStack input, boolean acceptTest) {
                IMachineRecipeList.RecipeEntry entry = ElectricFurnaceRecipeList.this.getRecipeInAndOutput(input, true);
                if (!acceptTest) {
                    input = input.func_77946_l();
                    input.func_190918_g(entry.getInput().getAmount());
                }
                return new MachineRecipe<ItemStack, ItemStack>(entry.getInput().getInputs().get(0), entry.getOutput().copy().getRecipeOutput(BasicMachineRecipeList.rand, new NBTTagCompound()).get(0)).getResult(input);
            }

            @Override
            public Iterable<? extends MachineRecipe<ItemStack, ItemStack>> getRecipes() {
                return new FuranceIter(ElectricFurnaceRecipeList.this);
            }

            @Override
            public boolean isIterable() {
                return true;
            }
        };
    }

    public class FuranceIter
    implements Iterable<MachineRecipe<ItemStack, ItemStack>> {
        IMachineRecipeList list;

        public FuranceIter(IMachineRecipeList par1) {
            this.list = par1;
        }

        @Override
        public Iterator<MachineRecipe<ItemStack, ItemStack>> iterator() {
            return new Iterator<MachineRecipe<ItemStack, ItemStack>>(){
                int index;
                IMachineRecipeList.RecipeEntry last;

                @Override
                public boolean hasNext() {
                    return FuranceIter.this.list.getRecipeMap().size() > this.index;
                }

                @Override
                public MachineRecipe<ItemStack, ItemStack> next() {
                    this.last = FuranceIter.this.list.getRecipeMap().get(this.index++);
                    return new MachineRecipe<ItemStack, ItemStack>(this.last.getInput().getInputs().get(0), this.last.getOutput().getAllOutputs().get(0));
                }

                @Override
                public void remove() {
                    if (this.last != null) {
                        FuranceIter.this.list.getRecipeMap().remove(this.last);
                    }
                }
            };
        }
    }
}

