/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med.logic;

import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.api.classic.reactor.IReactorPlannerComponent;
import ic2.core.block.machine.med.TileEntityReactorPlanner;
import ic2.core.block.machine.med.logic.PlannerRegistry;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.util.misc.StackUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class ReactorPlannerInv
implements IHasInventory,
INetworkFieldData {
    TileEntityReactorPlanner planner;
    ItemStack[] currentSet = new ItemStack[0];
    NonNullList<ItemStack> items = NonNullList.func_191197_a((int)15, (Object)ItemStack.field_190927_a);
    public int offset = 0;
    public byte type = (byte)-1;

    public ReactorPlannerInv(TileEntityReactorPlanner tile) {
        this.planner = tile;
    }

    public void create() {
        this.currentSet = this.getItemsFromType();
        this.init();
    }

    void init() {
        int start = this.offset * 3;
        for (int i = 0; i < 15; ++i) {
            int slot = start + i;
            if (slot >= this.currentSet.length) {
                this.items.set(i, (Object)ItemStack.field_190927_a);
                continue;
            }
            ItemStack stack = this.currentSet[slot];
            if (stack == null) {
                this.items.set(i, (Object)ItemStack.field_190927_a);
                continue;
            }
            this.items.set(i, (Object)StackUtil.copyWithSize(stack, 1));
        }
    }

    public boolean canDecrease() {
        return this.offset > 0;
    }

    public boolean canIncrease() {
        return this.offset * 3 + 15 < (this.currentSet == null ? 0 : this.currentSet.length);
    }

    public void setFilter(IReactorPlannerComponent.ReactorComponentType newType) {
        this.offset = 0;
        this.type = (byte)(newType == null ? -1 : newType.ordinal());
        this.currentSet = this.getItemsFromType();
        this.init();
    }

    public void setNextFilter() {
        IReactorPlannerComponent.ReactorComponentType[] array = IReactorPlannerComponent.ReactorComponentType.values();
        if (this.type + 1 >= array.length) {
            this.setFilter(null);
            return;
        }
        this.setFilter(array[this.type + 1]);
    }

    public void applyOffset(int extra) {
        if (extra > 0) {
            int realOffset = this.offset * 3 + 15;
            if (realOffset >= this.currentSet.length) {
                return;
            }
            this.offset += extra;
            int max = (this.currentSet.length - 15) / 3 + 1;
            if (this.offset > max) {
                this.offset = max;
            }
            this.init();
        } else if (extra < 0) {
            this.offset += extra;
            if (this.offset < 0) {
                this.offset = 0;
            }
            this.init();
        }
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @Override
    public int getSlotCount() {
        return 15;
    }

    @Override
    public int getMaxStackSize(int slot) {
        return 1;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return true;
    }

    public ItemStack[] getItemsFromType() {
        return PlannerRegistry.getItemsByType(this.type, this.planner.isSteamReactor);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.type = nbt.func_74771_c("Type");
        this.offset = nbt.func_74762_e("Offset");
        this.currentSet = this.getItemsFromType();
        this.init();
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("Type", this.type);
        nbt.func_74768_a("Offset", this.offset);
    }

    @Override
    public void read(IInputBuffer buffer) {
        this.type = buffer.readByte();
        this.offset = buffer.readInt();
        this.currentSet = new ItemStack[buffer.readInt()];
    }

    @Override
    public void write(IOutputBuffer buffer) {
        buffer.writeByte(this.type);
        buffer.writeInt(this.offset);
        buffer.writeInt(this.currentSet == null ? 0 : this.currentSet.length);
    }
}

