/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.power;

import javax.annotation.Nonnull;

public class PerTickIntAverageCalculator {
    private float lastSecondTotal = 0.0f;
    private int tickCount = 0;
    @Nonnull
    private final float[] secondsCache;
    private int writeIndex;
    private int writeSize;

    public PerTickIntAverageCalculator() {
        this(5);
    }

    public PerTickIntAverageCalculator(int numSeconds) {
        this.secondsCache = new float[numSeconds];
    }

    public float getAverage() {
        int numTicks = this.tickCount + this.writeSize * 20;
        if (numTicks == 0) {
            return 0.0f;
        }
        float totalPower = this.lastSecondTotal;
        int idx = this.writeIndex;
        int cnt = this.writeSize;
        while (cnt-- > 0) {
            totalPower += this.secondsCache[idx];
            if (++idx != this.secondsCache.length) continue;
            idx = 0;
        }
        return totalPower / (float)numTicks;
    }

    public void tick(long value) {
        this.lastSecondTotal += (float)value;
        ++this.tickCount;
        if (this.tickCount == 20) {
            this.secondsCache[this.writeIndex++] = this.lastSecondTotal;
            if (this.writeIndex > this.writeSize) {
                this.writeSize = this.writeIndex;
            }
            if (this.writeIndex == this.secondsCache.length) {
                this.writeIndex = 0;
            }
            this.lastSecondTotal = 0.0f;
            this.tickCount = 0;
        }
    }
}

