/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.rifts.registry;

import net.minecraft.nbt.NBTTagCompound;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.nbt.NBTUtils;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.rifts.registry.LinkProperties;
import org.dimdev.dimdoors.shared.rifts.registry.RegistryVertex;
import org.dimdev.dimdoors.shared.rifts.registry.RiftRegistry;
import org.dimdev.dimdoors.shared.tileentities.TileEntityRift;

public class Rift
extends RegistryVertex {
    public Location location;
    public boolean isFloating;
    public LinkProperties properties;

    public Rift(Location location) {
        this.location = location;
    }

    @Override
    public void sourceGone(RegistryVertex source) {
        super.sourceGone(source);
        TileEntityRift riftTileEntity = (TileEntityRift)this.location.getTileEntity();
        if (source instanceof Rift) {
            riftTileEntity.sourceGone(((Rift)source).location);
        }
    }

    @Override
    public void targetGone(RegistryVertex target) {
        super.targetGone(target);
        TileEntityRift riftTileEntity = (TileEntityRift)this.location.getTileEntity();
        if (target instanceof Rift) {
            riftTileEntity.targetGone(((Rift)target).location);
        }
        riftTileEntity.updateColor();
    }

    public void targetChanged(RegistryVertex target) {
        DimDoors.log.debug("Rift " + this + " notified of target " + target + " having changed. Updating color.");
        ((TileEntityRift)this.location.getTileEntity()).updateColor();
    }

    public void markDirty() {
        RiftRegistry.instance().markSubregistryDirty(this.dim);
        ((TileEntityRift)this.location.getTileEntity()).updateColor();
        for (Location location : RiftRegistry.instance().getSources(this.location)) {
            RiftRegistry.instance().getRift(location).targetChanged(this);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        NBTUtils.readFromNBT(this, nbt);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        return NBTUtils.writeToNBT(this, nbt);
    }

    public Rift() {
    }

    public Rift(Location location, boolean isFloating, LinkProperties properties) {
        this.location = location;
        this.isFloating = isFloating;
        this.properties = properties;
    }

    @Override
    public String toString() {
        return "Rift(location=" + this.location + ", isFloating=" + this.isFloating + ", properties=" + this.properties + ")";
    }
}

