/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.energyconverters.common.energy;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.Optional;
import net.xalcon.energyconverters.common.EnergyConvertersConfig;
import net.xalcon.energyconverters.common.energy.IEnergyBridgeInputAccessProvider;

@Optional.Interface(iface="buildcraft.api.mj.IMjReceiver", modid="buildcraftcore")
public class BuildcraftConsumptionHandler
implements IMjReceiver {
    private static final long requestPower = 1000000L * MjAPI.MJ;
    private IEnergyBridgeInputAccessProvider energyBridge;

    public BuildcraftConsumptionHandler(IEnergyBridgeInputAccessProvider energyBridge) {
        this.energyBridge = energyBridge;
    }

    public long getPowerRequested() {
        double free = this.energyBridge.getBridgeEnergyStoredMax() - this.energyBridge.getBridgeEnergyStored();
        long requested = (long)(free / EnergyConvertersConfig.mjConversion) * MjAPI.MJ;
        return requested;
    }

    public long receivePower(long microJoules, boolean simulate) {
        double availablePowerFe = (double)microJoules / (double)MjAPI.MJ * EnergyConvertersConfig.mjConversion;
        double usedFe = this.energyBridge.addEnergyToBridge(availablePowerFe, simulate);
        double usedMicroMj = usedFe * (double)MjAPI.MJ / EnergyConvertersConfig.mjConversion;
        return (long)((double)microJoules - usedMicroMj);
    }

    public boolean canConnect(@Nonnull IMjConnector other) {
        return true;
    }
}

