/*
 * Decompiled with CFR 0.152.
 */
package com.github.cpburnz.minecraft_prometheus_exporter;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger LOG = LogManager.getLogger();
    public boolean collector_jvm;
    public boolean collector_mc;
    private Configuration forge_spec;
    private InternalSpec internal_spec;
    private boolean is_loaded;
    public String web_listen_address;
    public int web_listen_port;

    public boolean isLoaded() {
        return this.is_loaded;
    }

    public void loadValues(File file) {
        this.forge_spec = new Configuration(file, true);
        this.internal_spec = new InternalSpec(this.forge_spec);
        this.collector_jvm = this.internal_spec.collector_jvm.getBoolean();
        this.collector_mc = this.internal_spec.collector_mc.getBoolean();
        this.web_listen_address = this.internal_spec.web_listen_address.getString();
        this.web_listen_port = this.internal_spec.web_listen_port.getInt();
        this.is_loaded = true;
        LOG.debug("collector.jvm: {}", (Object)this.collector_jvm);
        LOG.debug("collector.mc: {}", (Object)this.collector_mc);
        LOG.debug("web.listen_address: {}", (Object)this.web_listen_address);
        LOG.debug("web.listen_port: {}", (Object)this.web_listen_port);
    }

    private static class InternalSpec {
        private static final String DEFAULT_ADDRESS = "0.0.0.0";
        private static final int DEFAULT_PORT = 19565;
        private static final int TCP_PORT_MAX = 65535;
        private static final int TCP_PORT_MIN = 0;
        public final Property collector_jvm;
        public final Property collector_mc;
        public final Property web_listen_address;
        public final Property web_listen_port;

        public InternalSpec(Configuration config) {
            config.getCategory("collector").setComment("Collector settings.");
            this.collector_jvm = config.get("collector", "jvm", true);
            this.collector_jvm.setComment("Enable collecting metrics about the JVM process.");
            this.collector_mc = config.get("collector", "mc", true);
            this.collector_mc.setComment("Enable collecting metrics about the Minecraft server.");
            config.getCategory("web").setComment("Web server settings.");
            this.web_listen_address = config.get("web", "listen_address", DEFAULT_ADDRESS);
            this.web_listen_address.setComment("The IP address to listen on. To only allow connections from the local machine, use \"127.0.0.1\". To allow connections from remote machines, use \"0.0.0.0\".");
            this.web_listen_port = config.get("web", "listen_port", 19565).setMinValue(0).setMaxValue(65535);
            this.web_listen_port.setComment("The TCP port to listen on. Ports 1-1023 will not work unless Minecraft is run as root which is not recommended. Range is 0-65535");
            if (config.hasChanged()) {
                config.save();
            }
        }
    }
}

