/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.libs.com.google.common.collect;

import com.thevoxelbox.voxelsniper.libs.com.google.common.annotations.GwtCompatible;
import com.thevoxelbox.voxelsniper.libs.com.google.common.annotations.VisibleForTesting;
import com.thevoxelbox.voxelsniper.libs.com.google.common.collect.Hashing;
import com.thevoxelbox.voxelsniper.libs.com.google.common.collect.ImmutableList;
import com.thevoxelbox.voxelsniper.libs.com.google.common.collect.ImmutableSet;
import com.thevoxelbox.voxelsniper.libs.com.google.common.collect.Iterators;
import com.thevoxelbox.voxelsniper.libs.com.google.common.collect.RegularImmutableAsList;
import com.thevoxelbox.voxelsniper.libs.com.google.common.collect.UnmodifiableIterator;

@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableSet<E>
extends ImmutableSet<E> {
    private final Object[] elements;
    @VisibleForTesting
    final transient Object[] table;
    private final transient int mask;
    private final transient int hashCode;

    RegularImmutableSet(Object[] elements, int hashCode, Object[] table, int mask) {
        this.elements = elements;
        this.table = table;
        this.mask = mask;
        this.hashCode = hashCode;
    }

    @Override
    public boolean contains(Object target) {
        if (target == null) {
            return false;
        }
        int i = Hashing.smear(target.hashCode());
        Object candidate;
        while ((candidate = this.table[i & this.mask]) != null) {
            if (candidate.equals(target)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.forArray(this.elements);
    }

    @Override
    int copyIntoArray(Object[] dst, int offset) {
        System.arraycopy(this.elements, 0, dst, offset, this.elements.length);
        return offset + this.elements.length;
    }

    @Override
    ImmutableList<E> createAsList() {
        return new RegularImmutableAsList(this, this.elements);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }
}

