/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.jsap;

import com.thevoxelbox.voxelsniper.libs.com.martiansoftware.jsap.JSAP;
import com.thevoxelbox.voxelsniper.libs.com.martiansoftware.jsap.JSAPException;
import com.thevoxelbox.voxelsniper.libs.com.martiansoftware.jsap.JSAPResult;
import com.thevoxelbox.voxelsniper.libs.com.martiansoftware.jsap.Switch;
import com.thevoxelbox.voxelsniper.libs.com.martiansoftware.util.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;

public class HelpJSAP
extends JSAP {
    private String name;
    private String explanation;
    private int screenWidth;

    public HelpJSAP(String name, String explanation, int screenWidth) {
        this.name = name;
        this.explanation = explanation;
        this.screenWidth = screenWidth;
        try {
            this.registerParameter(new Switch("help", '\u0000', "help", "Displays this help page."));
        }
        catch (JSAPException jSAPException) {
            // empty catch block
        }
    }

    public HelpJSAP(String name, String explanation, int screenWidth, String resourceName) throws IOException, JSAPException {
        super(resourceName);
        this.name = name;
        this.explanation = explanation;
        this.screenWidth = screenWidth;
        try {
            this.registerParameter(new Switch("help", '\u0000', "help", "Displays this help page."));
        }
        catch (JSAPException jSAPException) {
            // empty catch block
        }
    }

    public HelpJSAP(String name, String explanation, int screenWidth, URL jsapXML) throws IOException, JSAPException {
        super(jsapXML);
        this.name = name;
        this.explanation = explanation;
        this.screenWidth = screenWidth;
        try {
            this.registerParameter(new Switch("help", '\u0000', "help", "Displays this help page."));
        }
        catch (JSAPException jSAPException) {
            // empty catch block
        }
    }

    public final String getExplanation() {
        return this.explanation;
    }

    public final void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final int getScreenWidth() {
        return this.screenWidth;
    }

    public final void setScreenWidth(int screenWidth) {
        this.screenWidth = screenWidth;
    }

    public final List<String> writeHelpOrErrorMessageIfRequired(JSAPResult jsapResult) {
        if (!jsapResult.success() || jsapResult.getBoolean("help")) {
            LinkedList<String> returnValue = new LinkedList<String>();
            if (!jsapResult.getBoolean("help")) {
                Iterator err = jsapResult.getErrorMessageIterator();
                while (err.hasNext()) {
                    returnValue.add(ChatColor.RED + "Error: " + ChatColor.DARK_RED + err.next());
                }
                return returnValue;
            }
            returnValue.add(ChatColor.GOLD + "Usage:");
            List l = StringUtils.wrapToList(this.name + " " + this.getUsage(), this.screenWidth);
            for (Object aL : l) {
                returnValue.add("  " + aL.toString());
            }
            if (this.explanation != null) {
                returnValue.add("");
                l = StringUtils.wrapToList(this.explanation, this.screenWidth);
                for (Object aL : l) {
                    String next = (String)aL;
                    returnValue.add(ChatColor.AQUA + next);
                }
            }
            returnValue.add("");
            returnValue.add(this.getHelp(this.screenWidth));
            return returnValue;
        }
        return Collections.emptyList();
    }
}

