/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.perform.PerformBrush;
import org.bukkit.ChatColor;

public class UnderlayBrush
extends PerformBrush {
    private static final int DEFAULT_DEPTH = 3;
    private int depth = 3;
    private boolean allBlocks = false;

    public UnderlayBrush() {
        this.setName("Underlay (Reverse Overlay)");
    }

    private void underlay(SnipeData v) {
        int[][] memory = new int[v.getBrushSize() * 2 + 1][v.getBrushSize() * 2 + 1];
        double brushSizeSquared = Math.pow((double)v.getBrushSize() + 0.5, 2.0);
        for (int z = v.getBrushSize(); z >= -v.getBrushSize(); --z) {
            for (int x = v.getBrushSize(); x >= -v.getBrushSize(); --x) {
                block5: for (int y = this.getTargetBlock().getY(); y < this.getTargetBlock().getY() + this.depth; ++y) {
                    int d;
                    if (memory[x + v.getBrushSize()][z + v.getBrushSize()] == 1 || !(Math.pow(x, 2.0) + Math.pow(z, 2.0) <= brushSizeSquared)) continue;
                    if (!this.allBlocks) {
                        switch (this.getBlockIdAt(this.getTargetBlock().getX() + x, y, this.getTargetBlock().getZ() + z)) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 12: 
                            case 13: 
                            case 24: 
                            case 48: 
                            case 49: 
                            case 78: 
                            case 82: {
                                for (d = 0; d < this.depth; ++d) {
                                    if (this.clampY(this.getTargetBlock().getX() + x, y + d, this.getTargetBlock().getZ() + z).getTypeId() == 0) continue;
                                    this.current.perform(this.clampY(this.getTargetBlock().getX() + x, y + d, this.getTargetBlock().getZ() + z));
                                    memory[x + v.getBrushSize()][z + v.getBrushSize()] = 1;
                                }
                                continue block5;
                            }
                        }
                        continue;
                    }
                    for (d = 0; d < this.depth; ++d) {
                        if (this.clampY(this.getTargetBlock().getX() + x, y + d, this.getTargetBlock().getZ() + z).getTypeId() == 0) continue;
                        this.current.perform(this.clampY(this.getTargetBlock().getX() + x, y + d, this.getTargetBlock().getZ() + z));
                        memory[x + v.getBrushSize()][z + v.getBrushSize()] = 1;
                    }
                }
            }
        }
        v.owner().storeUndo(this.current.getUndo());
    }

    private void underlay2(SnipeData v) {
        int[][] memory = new int[v.getBrushSize() * 2 + 1][v.getBrushSize() * 2 + 1];
        double brushSizeSquared = Math.pow((double)v.getBrushSize() + 0.5, 2.0);
        for (int z = v.getBrushSize(); z >= -v.getBrushSize(); --z) {
            for (int x = v.getBrushSize(); x >= -v.getBrushSize(); --x) {
                block5: for (int y = this.getTargetBlock().getY(); y < this.getTargetBlock().getY() + this.depth; ++y) {
                    int d;
                    if (memory[x + v.getBrushSize()][z + v.getBrushSize()] == 1 || !(Math.pow(x, 2.0) + Math.pow(z, 2.0) <= brushSizeSquared)) continue;
                    if (!this.allBlocks) {
                        switch (this.getBlockIdAt(this.getTargetBlock().getX() + x, y, this.getTargetBlock().getZ() + z)) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 12: 
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 24: 
                            case 48: 
                            case 49: 
                            case 78: 
                            case 82: {
                                for (d = -1; d < this.depth - 1; ++d) {
                                    this.current.perform(this.clampY(this.getTargetBlock().getX() + x, y - d, this.getTargetBlock().getZ() + z));
                                    memory[x + v.getBrushSize()][z + v.getBrushSize()] = 1;
                                }
                                continue block5;
                            }
                        }
                        continue;
                    }
                    for (d = -1; d < this.depth - 1; ++d) {
                        this.current.perform(this.clampY(this.getTargetBlock().getX() + x, y - d, this.getTargetBlock().getZ() + z));
                        memory[x + v.getBrushSize()][z + v.getBrushSize()] = 1;
                    }
                }
            }
        }
        v.owner().storeUndo(this.current.getUndo());
    }

    @Override
    public final void arrow(SnipeData v) {
        this.underlay(v);
    }

    @Override
    public final void powder(SnipeData v) {
        this.underlay2(v);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 1; i < par.length; ++i) {
            if (par[i].equalsIgnoreCase("info")) {
                v.owner().getPlayer().sendMessage(ChatColor.GOLD + "Reverse Overlay brush parameters:");
                v.owner().getPlayer().sendMessage(ChatColor.AQUA + "d[number] (ex: d3) The number of blocks thick to change.");
                v.owner().getPlayer().sendMessage(ChatColor.BLUE + "all (ex: /b reover all) Sets the brush to affect ALL materials");
                if (this.depth < 1) {
                    this.depth = 1;
                }
                return;
            }
            if (par[i].startsWith("d")) {
                this.depth = Integer.parseInt(par[i].replace("d", ""));
                v.owner().getPlayer().sendMessage(ChatColor.AQUA + "Depth set to " + this.depth);
                continue;
            }
            if (par[i].startsWith("all")) {
                this.allBlocks = true;
                v.owner().getPlayer().sendMessage(ChatColor.BLUE + "Will underlay over any block." + this.depth);
                continue;
            }
            if (par[i].startsWith("some")) {
                this.allBlocks = false;
                v.owner().getPlayer().sendMessage(ChatColor.BLUE + "Will underlay only natural block types." + this.depth);
                continue;
            }
            v.owner().getPlayer().sendMessage(ChatColor.RED + "Invalid brush parameters! use the info parameter to display parameter info.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.underlay";
    }
}

