/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import com.thevoxelbox.voxelsniper.libs.com.google.common.base.Objects;
import com.thevoxelbox.voxelsniper.util.UndoDelegate;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;

public class TreeSnipeBrush
extends Brush {
    private TreeType treeType = TreeType.TREE;

    public TreeSnipeBrush() {
        this.setName("Tree Snipe");
    }

    private void single(SnipeData v, Block targetBlock) {
        UndoDelegate undoDelegate = new UndoDelegate(targetBlock.getWorld());
        Block blockBelow = targetBlock.getRelative(BlockFace.DOWN);
        BlockState currentState = blockBelow.getState();
        undoDelegate.setBlock(blockBelow);
        blockBelow.setType(Material.GRASS);
        this.getWorld().generateTree(targetBlock.getLocation(), this.treeType, (BlockChangeDelegate)undoDelegate);
        Undo undo = undoDelegate.getUndo();
        blockBelow.setTypeIdAndData(currentState.getTypeId(), currentState.getRawData(), true);
        undo.put(blockBelow);
        v.owner().storeUndo(undo);
    }

    private int getYOffset() {
        for (int i = 1; i < this.getTargetBlock().getWorld().getMaxHeight() - 1 - this.getTargetBlock().getY(); ++i) {
            if (!Objects.equal(this.getTargetBlock().getRelative(0, i + 1, 0).getType(), Material.AIR)) continue;
            return i;
        }
        return 0;
    }

    private void printTreeType(Message vm) {
        String printout = "";
        boolean delimiterHelper = true;
        for (TreeType treeType : TreeType.values()) {
            if (delimiterHelper) {
                delimiterHelper = false;
            } else {
                printout = printout + ", ";
            }
            printout = printout + (treeType.equals((Object)this.treeType) ? ChatColor.GRAY + treeType.name().toLowerCase() : ChatColor.DARK_GRAY + treeType.name().toLowerCase()) + ChatColor.WHITE;
        }
        vm.custom(printout);
    }

    @Override
    protected final void arrow(SnipeData v) {
        Block targetBlock = this.getTargetBlock().getRelative(0, this.getYOffset(), 0);
        this.single(v, targetBlock);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.single(v, this.getTargetBlock());
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        this.printTreeType(vm);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 1; i < par.length; ++i) {
            if (par[i].equalsIgnoreCase("info")) {
                v.sendMessage(ChatColor.GOLD + "Tree snipe brush:");
                v.sendMessage(ChatColor.AQUA + "/b t treetype");
                this.printTreeType(v.getVoxelMessage());
                return;
            }
            try {
                this.treeType = TreeType.valueOf((String)par[i].toUpperCase());
                this.printTreeType(v.getVoxelMessage());
                continue;
            }
            catch (IllegalArgumentException exception) {
                v.getVoxelMessage().brushMessage("No such tree type.");
            }
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.treesnipe";
    }
}

