/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import com.thevoxelbox.voxelsniper.libs.com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;

public class StencilBrush
extends Brush {
    private byte pasteOption = 1;
    private String filename = "NoFileLoaded";
    private short x;
    private short z;
    private short y;
    private short xRef;
    private short zRef;
    private short yRef;
    private byte pasteParam = 0;
    private int[] firstPoint = new int[3];
    private int[] secondPoint = new int[3];
    private int[] pastePoint = new int[3];
    private byte point = 1;

    public StencilBrush() {
        this.setName("Stencil");
    }

    private void stencilPaste(SnipeData v) {
        if (this.filename.matches("NoFileLoaded")) {
            v.sendMessage(ChatColor.RED + "You did not specify a filename.  This is required.");
            return;
        }
        Undo undo = new Undo();
        File file = new File("plugins/VoxelSniper/stencils/" + this.filename + ".vstencil");
        if (file.exists()) {
            try {
                DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                this.x = in.readShort();
                this.z = in.readShort();
                this.y = in.readShort();
                this.xRef = in.readShort();
                this.zRef = in.readShort();
                this.yRef = in.readShort();
                int numRuns = in.readInt();
                int currX = -this.xRef;
                int currZ = -this.zRef;
                int currY = -this.yRef;
                int blockPositionX = this.getTargetBlock().getX();
                int blockPositionY = this.getTargetBlock().getY();
                int blockPositionZ = this.getTargetBlock().getZ();
                if (this.pasteOption == 0) {
                    for (int i = 1; i < numRuns + 1; ++i) {
                        if (in.readBoolean()) {
                            int numLoops = in.readByte() + 128;
                            int id = in.readByte() + 128;
                            int data = in.readByte() + 128;
                            for (int j = 0; j < numLoops; ++j) {
                                undo.put(this.clampY(blockPositionX + currX, blockPositionY + currY, blockPositionZ + currZ));
                                this.clampY(blockPositionX + currX, blockPositionY + currY, blockPositionZ + currZ).setTypeIdAndData(id, (byte)data, false);
                                if (++currX != this.x - this.xRef) continue;
                                currX = -this.xRef;
                                if (++currZ != this.z - this.zRef) continue;
                                currZ = -this.zRef;
                                ++currY;
                            }
                            continue;
                        }
                        undo.put(this.clampY(blockPositionX + currX, blockPositionY + currY, blockPositionZ + currZ));
                        this.clampY(blockPositionX + currX, blockPositionY + currY, blockPositionZ + currZ).setTypeIdAndData(in.readByte() + 128, (byte)(in.readByte() + 128), false);
                        if (++currX != this.x - this.xRef) continue;
                        currX = -this.xRef;
                        if (++currZ != this.z - this.zRef) continue;
                        currZ = -this.zRef;
                        ++currY;
                    }
                } else if (this.pasteOption == 1) {
                    for (int i = 1; i < numRuns + 1; ++i) {
                        int data;
                        int id;
                        if (in.readBoolean()) {
                            int numLoops = in.readByte() + 128;
                            id = in.readByte() + 128;
                            data = in.readByte() + 128;
                            for (int j = 0; j < numLoops; ++j) {
                                if (id != 0 && this.clampY(blockPositionX + currX, blockPositionY + currY, blockPositionZ + currZ).getTypeId() == 0) {
                                    undo.put(this.clampY(blockPositionX + currX, blockPositionY + currY, blockPositionZ + currZ));
                                    this.clampY(blockPositionX + currX, blockPositionY + currY, blockPositionZ + currZ).setTypeIdAndData(id, (byte)data, false);
                                }
                                if (++currX != this.x - this.xRef) continue;
                                currX = -this.xRef;
                                if (++currZ != this.z - this.zRef) continue;
                                currZ = -this.zRef;
                                ++currY;
                            }
                            continue;
                        }
                        id = in.readByte() + 128;
                        data = in.readByte() + 128;
                        if (id != 0 && this.clampY(blockPositionX + currX, blockPositionY + currY, blockPositionZ + currZ).getTypeId() == 0) {
                            undo.put(this.clampY(blockPositionX + currX, blockPositionY + currY, blockPositionZ + currZ));
                            this.clampY(blockPositionX + currX, blockPositionY + currY, blockPositionZ + currZ).setTypeIdAndData(id, (byte)data, false);
                        }
                        if (++currX != this.x - this.xRef) continue;
                        currX = -this.xRef;
                        if (++currZ != this.z - this.zRef) continue;
                        currZ = -this.zRef;
                        ++currY;
                    }
                } else {
                    for (int i = 1; i < numRuns + 1; ++i) {
                        int data;
                        int id;
                        if (in.readBoolean()) {
                            int numLoops = in.readByte() + 128;
                            id = in.readByte() + 128;
                            data = in.readByte() + 128;
                            for (int j = 0; j < numLoops; ++j) {
                                if (id != 0) {
                                    undo.put(this.clampY(blockPositionX + currX, blockPositionY + currY, blockPositionZ + currZ));
                                    this.clampY(blockPositionX + currX, blockPositionY + currY, blockPositionZ + currZ).setTypeIdAndData(id, (byte)data, false);
                                }
                                if (++currX != this.x - this.xRef) continue;
                                currX = -this.xRef;
                                if (++currZ != this.z - this.zRef) continue;
                                currZ = -this.zRef;
                                ++currY;
                            }
                            continue;
                        }
                        id = in.readByte() + 128;
                        data = in.readByte() + 128;
                        if (id != 0) {
                            undo.put(this.clampY(blockPositionX + currX, blockPositionY + currY, blockPositionZ + currZ));
                            this.clampY(blockPositionX + currX, blockPositionY + currY, blockPositionZ + currZ).setTypeIdAndData(id, (byte)data, false);
                        }
                        if (++currX != this.x) continue;
                        currX = 0;
                        if (++currZ != this.z) continue;
                        currZ = 0;
                        ++currY;
                    }
                }
                in.close();
                v.owner().storeUndo(undo);
            }
            catch (Exception exception) {
                v.sendMessage(ChatColor.RED + "Something went wrong.");
                exception.printStackTrace();
            }
        } else {
            v.sendMessage(ChatColor.RED + "You need to type a stencil name / your specified stencil does not exist.");
        }
    }

    private void stencilSave(SnipeData v) {
        File file = new File("plugins/VoxelSniper/stencils/" + this.filename + ".vstencil");
        try {
            this.x = (short)(Math.abs(this.firstPoint[0] - this.secondPoint[0]) + 1);
            this.z = (short)(Math.abs(this.firstPoint[1] - this.secondPoint[1]) + 1);
            this.y = (short)(Math.abs(this.firstPoint[2] - this.secondPoint[2]) + 1);
            this.xRef = (short)(this.firstPoint[0] > this.secondPoint[0] ? this.pastePoint[0] - this.secondPoint[0] : this.pastePoint[0] - this.firstPoint[0]);
            this.zRef = (short)(this.firstPoint[1] > this.secondPoint[1] ? this.pastePoint[1] - this.secondPoint[1] : this.pastePoint[1] - this.firstPoint[1]);
            this.yRef = (short)(this.firstPoint[2] > this.secondPoint[2] ? this.pastePoint[2] - this.secondPoint[2] : this.pastePoint[2] - this.firstPoint[2]);
            if (this.x * this.y * this.z > 50000) {
                v.sendMessage(ChatColor.AQUA + "Volume exceeds maximum limit.");
                return;
            }
            Files.createParentDirs(file);
            file.createNewFile();
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            int blockPositionX = this.firstPoint[0] > this.secondPoint[0] ? this.secondPoint[0] : this.firstPoint[0];
            int blockPositionZ = this.firstPoint[1] > this.secondPoint[1] ? this.secondPoint[1] : this.firstPoint[1];
            int blockPositionY = this.firstPoint[2] > this.secondPoint[2] ? this.secondPoint[2] : this.firstPoint[2];
            out.writeShort(this.x);
            out.writeShort(this.z);
            out.writeShort(this.y);
            out.writeShort(this.xRef);
            out.writeShort(this.zRef);
            out.writeShort(this.yRef);
            v.sendMessage(ChatColor.AQUA + "Volume: " + this.x * this.z * this.y + " blockPositionX:" + blockPositionX + " blockPositionZ:" + blockPositionZ + " blockPositionY:" + blockPositionY);
            byte[] blockArray = new byte[this.x * this.z * this.y];
            byte[] dataArray = new byte[this.x * this.z * this.y];
            byte[] runSizeArray = new byte[this.x * this.z * this.y];
            byte lastId = (byte)(this.getWorld().getBlockTypeIdAt(blockPositionX, blockPositionY, blockPositionZ) - 128);
            byte lastData = (byte)(this.clampY(blockPositionX, blockPositionY, blockPositionZ).getData() - 128);
            int counter = 0;
            int arrayIndex = 0;
            for (int y = 0; y < this.y; ++y) {
                for (int z = 0; z < this.z; ++z) {
                    for (int x = 0; x < this.x; ++x) {
                        Block currentBlock = this.getWorld().getBlockAt(blockPositionX + x, blockPositionY + y, blockPositionZ + z);
                        byte thisId = (byte)(currentBlock.getTypeId() - 128);
                        byte thisData = (byte)(currentBlock.getData() - 128);
                        if (thisId != lastId || thisData != lastData || counter == 255) {
                            blockArray[arrayIndex] = lastId;
                            dataArray[arrayIndex] = lastData;
                            runSizeArray[arrayIndex] = (byte)(counter - 128);
                            ++arrayIndex;
                            counter = 1;
                            lastId = thisId;
                            lastData = thisData;
                            continue;
                        }
                        ++counter;
                        lastId = thisId;
                        lastData = thisData;
                    }
                }
            }
            blockArray[arrayIndex] = lastId;
            dataArray[arrayIndex] = lastData;
            runSizeArray[arrayIndex] = (byte)(counter - 128);
            out.writeInt(arrayIndex + 1);
            for (int i = 0; i < arrayIndex + 1; ++i) {
                if (runSizeArray[i] > -127) {
                    out.writeBoolean(true);
                    out.writeByte(runSizeArray[i]);
                    out.writeByte(blockArray[i]);
                    out.writeByte(dataArray[i]);
                    continue;
                }
                out.writeBoolean(false);
                out.writeByte(blockArray[i]);
                out.writeByte(dataArray[i]);
            }
            v.sendMessage(ChatColor.BLUE + "Saved as '" + this.filename + "'.");
            out.close();
        }
        catch (Exception exception) {
            v.sendMessage(ChatColor.RED + "Something went wrong.");
            exception.printStackTrace();
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        if (this.point == 1) {
            this.firstPoint[0] = this.getTargetBlock().getX();
            this.firstPoint[1] = this.getTargetBlock().getZ();
            this.firstPoint[2] = this.getTargetBlock().getY();
            v.sendMessage(ChatColor.GRAY + "First point");
            v.sendMessage("X:" + this.firstPoint[0] + " Z:" + this.firstPoint[1] + " Y:" + this.firstPoint[2]);
            this.point = (byte)2;
        } else if (this.point == 2) {
            this.secondPoint[0] = this.getTargetBlock().getX();
            this.secondPoint[1] = this.getTargetBlock().getZ();
            this.secondPoint[2] = this.getTargetBlock().getY();
            if (Math.abs(this.firstPoint[0] - this.secondPoint[0]) * Math.abs(this.firstPoint[1] - this.secondPoint[1]) * Math.abs(this.firstPoint[2] - this.secondPoint[2]) > 5000000) {
                v.sendMessage(ChatColor.DARK_RED + "Area selected is too large. (Limit is 5,000,000 blocks)");
                this.point = 1;
            } else {
                v.sendMessage(ChatColor.GRAY + "Second point");
                v.sendMessage("X:" + this.secondPoint[0] + " Z:" + this.secondPoint[1] + " Y:" + this.secondPoint[2]);
                this.point = (byte)3;
            }
        } else if (this.point == 3) {
            this.pastePoint[0] = this.getTargetBlock().getX();
            this.pastePoint[1] = this.getTargetBlock().getZ();
            this.pastePoint[2] = this.getTargetBlock().getY();
            v.sendMessage(ChatColor.GRAY + "Paste Reference point");
            v.sendMessage("X:" + this.pastePoint[0] + " Z:" + this.pastePoint[1] + " Y:" + this.pastePoint[2]);
            this.point = 1;
            this.stencilSave(v);
        }
    }

    @Override
    protected final void powder(SnipeData v) {
        this.stencilPaste(v);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom("File loaded: " + this.filename);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        if (par[1].equalsIgnoreCase("info")) {
            v.sendMessage(ChatColor.GOLD + "Stencil brush Parameters:");
            v.sendMessage(ChatColor.AQUA + "/b schem [optional: 'full' 'fill' or 'replace', with fill as default] [name] -- Loads the specified schematic.  Allowed size of schematic is based on rank.  Full/fill/replace must come first.  Full = paste all blocks, fill = paste only into air blocks, replace = paste full blocks in only, but replace anything in their way.");
            v.sendMessage(ChatColor.BLUE + "Size of the stencils you are allowed to paste depends on rank (member / lite, sniper, curator, admin)");
            return;
        }
        if (par[1].equalsIgnoreCase("full")) {
            this.pasteOption = 0;
            this.pasteParam = 1;
        } else if (par[1].equalsIgnoreCase("fill")) {
            this.pasteOption = 1;
            this.pasteParam = 1;
        } else if (par[1].equalsIgnoreCase("replace")) {
            this.pasteOption = (byte)2;
            this.pasteParam = 1;
        }
        try {
            this.filename = par[1 + this.pasteParam];
            File file = new File("plugins/VoxelSniper/stencils/" + this.filename + ".vstencil");
            if (file.exists()) {
                v.sendMessage(ChatColor.RED + "Stencil '" + this.filename + "' exists and was loaded.  Make sure you are using powder if you do not want any chance of overwriting the file.");
            } else {
                v.sendMessage(ChatColor.AQUA + "Stencil '" + this.filename + "' does not exist.  Ready to be saved to, but cannot be pasted.");
            }
        }
        catch (Exception exception) {
            v.sendMessage(ChatColor.RED + "You need to type a stencil name.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.stencil";
    }
}

