/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.perform.PerformBrush;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;

public class SplineBrush
extends PerformBrush {
    private final ArrayList<Block> endPts = new ArrayList();
    private final ArrayList<Block> ctrlPts = new ArrayList();
    protected ArrayList<Point> spline = new ArrayList();
    protected boolean set;
    protected boolean ctrl;
    protected String[] sparams = new String[]{"ss", "sc", "clear"};

    public SplineBrush() {
        this.setName("Spline");
    }

    public final void addToSet(SnipeData v, boolean ep, Block targetBlock) {
        if (ep) {
            if (this.endPts.contains(targetBlock) || this.endPts.size() == 2) {
                return;
            }
            this.endPts.add(targetBlock);
            v.sendMessage(ChatColor.GRAY + "Added block " + ChatColor.RED + "(" + targetBlock.getX() + ", " + targetBlock.getY() + ", " + targetBlock.getZ() + ") " + ChatColor.GRAY + "to endpoint selection");
            return;
        }
        if (this.ctrlPts.contains(targetBlock) || this.ctrlPts.size() == 2) {
            return;
        }
        this.ctrlPts.add(targetBlock);
        v.sendMessage(ChatColor.GRAY + "Added block " + ChatColor.RED + "(" + targetBlock.getX() + ", " + targetBlock.getY() + ", " + targetBlock.getZ() + ") " + ChatColor.GRAY + "to control point selection");
    }

    public final void removeFromSet(SnipeData v, boolean ep, Block targetBlock) {
        if (ep) {
            if (!this.endPts.contains(targetBlock)) {
                v.sendMessage(ChatColor.RED + "That block is not in the endpoint selection set.");
                return;
            }
            this.endPts.add(targetBlock);
            v.sendMessage(ChatColor.GRAY + "Removed block " + ChatColor.RED + "(" + targetBlock.getX() + ", " + targetBlock.getY() + ", " + targetBlock.getZ() + ") " + ChatColor.GRAY + "from endpoint selection");
            return;
        }
        if (!this.ctrlPts.contains(targetBlock)) {
            v.sendMessage(ChatColor.RED + "That block is not in the control point selection set.");
            return;
        }
        this.ctrlPts.remove(targetBlock);
        v.sendMessage(ChatColor.GRAY + "Removed block " + ChatColor.RED + "(" + targetBlock.getX() + ", " + targetBlock.getY() + ", " + targetBlock.getZ() + ") " + ChatColor.GRAY + "from control point selection");
    }

    public final boolean spline(Point start, Point end, Point c1, Point c2, SnipeData v) {
        this.spline.clear();
        try {
            Point c = c1.subtract(start).multiply(3);
            Point b = c2.subtract(c1).multiply(3).subtract(c);
            Point a = end.subtract(start).subtract(c).subtract(b);
            for (double t = 0.0; t < 1.0; t += 0.01) {
                int pz;
                int py;
                int px = (int)Math.round((double)a.getX() * (t * t * t) + (double)b.getX() * (t * t) + (double)c.getX() * t + (double)this.endPts.get(0).getX());
                if (this.spline.contains(new Point(px, py = (int)Math.round((double)a.getY() * (t * t * t) + (double)b.getY() * (t * t) + (double)c.getY() * t + (double)this.endPts.get(0).getY()), pz = (int)Math.round((double)a.getZ() * (t * t * t) + (double)b.getZ() * (t * t) + (double)c.getZ() * t + (double)this.endPts.get(0).getZ())))) continue;
                this.spline.add(new Point(px, py, pz));
            }
            return true;
        }
        catch (Exception exception) {
            v.sendMessage(ChatColor.RED + "Not enough points selected; " + this.endPts.size() + " endpoints, " + this.ctrlPts.size() + " control points");
            return false;
        }
    }

    protected final void render(SnipeData v) {
        if (this.spline.isEmpty()) {
            return;
        }
        for (Point point : this.spline) {
            this.current.perform(this.clampY(point.getX(), point.getY(), point.getZ()));
        }
        v.owner().storeUndo(this.current.getUndo());
    }

    @Override
    protected final void arrow(SnipeData v) {
        if (this.set) {
            this.removeFromSet(v, true, this.getTargetBlock());
        } else if (this.ctrl) {
            this.removeFromSet(v, false, this.getTargetBlock());
        }
    }

    protected final void clear(SnipeData v) {
        this.spline.clear();
        this.ctrlPts.clear();
        this.endPts.clear();
        v.sendMessage(ChatColor.GRAY + "Bezier curve cleared.");
    }

    @Override
    protected final void powder(SnipeData v) {
        if (this.set) {
            this.addToSet(v, true, this.getTargetBlock());
        }
        if (this.ctrl) {
            this.addToSet(v, false, this.getTargetBlock());
        }
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        if (this.set) {
            vm.custom(ChatColor.GRAY + "Endpoint selection mode ENABLED.");
        } else if (this.ctrl) {
            vm.custom(ChatColor.GRAY + "Control point selection mode ENABLED.");
        } else {
            vm.custom(ChatColor.AQUA + "No selection mode enabled.");
        }
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 1; i < par.length; ++i) {
            if (par[i].equalsIgnoreCase("info")) {
                v.sendMessage(ChatColor.GOLD + "Spline brush parameters");
                v.sendMessage(ChatColor.AQUA + "ss: Enable endpoint selection mode for desired curve");
                v.sendMessage(ChatColor.AQUA + "sc: Enable control point selection mode for desired curve");
                v.sendMessage(ChatColor.AQUA + "clear: Clear out the curve selection");
                v.sendMessage(ChatColor.AQUA + "ren: Render curve from control points");
                return;
            }
            if (par[i].equalsIgnoreCase("sc")) {
                if (!this.ctrl) {
                    this.set = false;
                    this.ctrl = true;
                    v.sendMessage(ChatColor.GRAY + "Control point selection mode ENABLED.");
                    continue;
                }
                this.ctrl = false;
                v.sendMessage(ChatColor.AQUA + "Control point selection mode disabled.");
                continue;
            }
            if (par[i].equalsIgnoreCase("ss")) {
                if (!this.set) {
                    this.set = true;
                    this.ctrl = false;
                    v.sendMessage(ChatColor.GRAY + "Endpoint selection mode ENABLED.");
                    continue;
                }
                this.set = false;
                v.sendMessage(ChatColor.AQUA + "Endpoint selection mode disabled.");
                continue;
            }
            if (par[i].equalsIgnoreCase("clear")) {
                this.clear(v);
                continue;
            }
            if (par[i].equalsIgnoreCase("ren")) {
                if (!this.spline(new Point(this.endPts.get(0)), new Point(this.endPts.get(1)), new Point(this.ctrlPts.get(0)), new Point(this.ctrlPts.get(1)), v)) continue;
                this.render(v);
                continue;
            }
            v.sendMessage(ChatColor.RED + "Invalid brush parameters! use the info parameter to display parameter info.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.spline";
    }

    protected class Point {
        private int x;
        private int y;
        private int z;

        public Point(Block b) {
            this.setX(b.getX());
            this.setY(b.getY());
            this.setZ(b.getZ());
        }

        public Point(int x, int y, int z) {
            this.setX(x);
            this.setY(y);
            this.setZ(z);
        }

        public final Point add(Point p) {
            return new Point(this.getX() + p.getX(), this.getY() + p.getY(), this.getZ() + p.getZ());
        }

        public final Point multiply(int scalar) {
            return new Point(this.getX() * scalar, this.getY() * scalar, this.getZ() * scalar);
        }

        public final Point subtract(Point p) {
            return new Point(this.getX() - p.getX(), this.getY() - p.getY(), this.getZ() - p.getZ());
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }

        public int getZ() {
            return this.z;
        }

        public void setZ(int z) {
            this.z = z;
        }
    }
}

