/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.perform.PerformBrush;
import java.util.Random;
import org.bukkit.ChatColor;

public class SplatterOverlayBrush
extends PerformBrush {
    private static final int GROW_PERCENT_MIN = 1;
    private static final int GROW_PERCENT_DEFAULT = 1000;
    private static final int GROW_PERCENT_MAX = 9999;
    private static final int SEED_PERCENT_MIN = 1;
    private static final int SEED_PERCENT_DEFAULT = 1000;
    private static final int SEED_PERCENT_MAX = 9999;
    private static final int SPLATREC_PERCENT_MIN = 1;
    private static final int SPLATREC_PERCENT_DEFAULT = 3;
    private static final int SPLATREC_PERCENT_MAX = 10;
    private int seedPercent;
    private int growPercent;
    private int splatterRecursions;
    private int yOffset = 0;
    private boolean randomizeHeight = false;
    private Random generator = new Random();
    private int depth = 3;
    private boolean allBlocks = false;

    public SplatterOverlayBrush() {
        this.setName("Splatter Overlay");
    }

    private void sOverlay(SnipeData v) {
        int[][] splat = new int[2 * v.getBrushSize() + 1][2 * v.getBrushSize() + 1];
        for (int x = 2 * v.getBrushSize(); x >= 0; --x) {
            for (int y = 2 * v.getBrushSize(); y >= 0; --y) {
                if (this.generator.nextInt(10000) > this.seedPercent) continue;
                splat[x][y] = 1;
            }
        }
        int gref = this.growPercent;
        int[][] tempSplat = new int[2 * v.getBrushSize() + 1][2 * v.getBrushSize() + 1];
        for (int r = 0; r < this.splatterRecursions; ++r) {
            int y;
            int x;
            this.growPercent = gref - gref / this.splatterRecursions * r;
            for (x = 2 * v.getBrushSize(); x >= 0; --x) {
                for (y = 2 * v.getBrushSize(); y >= 0; --y) {
                    tempSplat[x][y] = splat[x][y];
                    int growcheck = 0;
                    if (splat[x][y] == 0) {
                        if (x != 0 && splat[x - 1][y] == 1) {
                            ++growcheck;
                        }
                        if (y != 0 && splat[x][y - 1] == 1) {
                            ++growcheck;
                        }
                        if (x != 2 * v.getBrushSize() && splat[x + 1][y] == 1) {
                            ++growcheck;
                        }
                        if (y != 2 * v.getBrushSize() && splat[x][y + 1] == 1) {
                            ++growcheck;
                        }
                    }
                    if (growcheck < true || this.generator.nextInt(10000) > this.growPercent) continue;
                    tempSplat[x][y] = 1;
                }
            }
            for (x = 2 * v.getBrushSize(); x >= 0; --x) {
                for (y = 2 * v.getBrushSize(); y >= 0; --y) {
                    splat[x][y] = tempSplat[x][y];
                }
            }
        }
        this.growPercent = gref;
        int[][] memory = new int[2 * v.getBrushSize() + 1][2 * v.getBrushSize() + 1];
        double brushSizeSquared = Math.pow((double)v.getBrushSize() + 0.5, 2.0);
        for (int z = v.getBrushSize(); z >= -v.getBrushSize(); --z) {
            for (int x = v.getBrushSize(); x >= -v.getBrushSize(); --x) {
                block12: for (int y = this.getTargetBlock().getY(); y > 0; --y) {
                    int d;
                    int depth;
                    int check;
                    if (memory[x + v.getBrushSize()][z + v.getBrushSize()] == 1 || !(Math.pow(x, 2.0) + Math.pow(z, 2.0) <= brushSizeSquared) || splat[x + v.getBrushSize()][z + v.getBrushSize()] != 1 || (check = this.getBlockIdAt(this.getTargetBlock().getX() + x, y + 1, this.getTargetBlock().getZ() + z)) != 0 && check != 8 && check != 9) continue;
                    if (!this.allBlocks) {
                        switch (this.getBlockIdAt(this.getTargetBlock().getX() + x, y, this.getTargetBlock().getZ() + z)) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 12: 
                            case 13: 
                            case 24: 
                            case 48: 
                            case 49: 
                            case 78: 
                            case 82: {
                                depth = this.randomizeHeight ? this.generator.nextInt(this.depth) : this.depth;
                                d = this.depth - 1;
                                while (this.depth - d <= depth) {
                                    if (this.clampY(this.getTargetBlock().getX() + x, y - d, this.getTargetBlock().getZ() + z).getTypeId() != 0) {
                                        this.current.perform(this.clampY(this.getTargetBlock().getX() + x, y - d + this.yOffset, this.getTargetBlock().getZ() + z));
                                        memory[x + v.getBrushSize()][z + v.getBrushSize()] = 1;
                                    }
                                    --d;
                                }
                                continue block12;
                            }
                        }
                        continue;
                    }
                    depth = this.randomizeHeight ? this.generator.nextInt(this.depth) : this.depth;
                    d = this.depth - 1;
                    while (this.depth - d <= depth) {
                        if (this.clampY(this.getTargetBlock().getX() + x, y - d, this.getTargetBlock().getZ() + z).getTypeId() != 0) {
                            this.current.perform(this.clampY(this.getTargetBlock().getX() + x, y - d + this.yOffset, this.getTargetBlock().getZ() + z));
                            memory[x + v.getBrushSize()][z + v.getBrushSize()] = 1;
                        }
                        --d;
                    }
                }
            }
        }
        v.owner().storeUndo(this.current.getUndo());
    }

    private void soverlayTwo(SnipeData v) {
        int[][] splat = new int[2 * v.getBrushSize() + 1][2 * v.getBrushSize() + 1];
        for (int x = 2 * v.getBrushSize(); x >= 0; --x) {
            for (int y = 2 * v.getBrushSize(); y >= 0; --y) {
                if (this.generator.nextInt(10000) > this.seedPercent) continue;
                splat[x][y] = 1;
            }
        }
        int gref = this.growPercent;
        int[][] tempsplat = new int[2 * v.getBrushSize() + 1][2 * v.getBrushSize() + 1];
        for (int r = 0; r < this.splatterRecursions; ++r) {
            int y;
            int x;
            this.growPercent = gref - gref / this.splatterRecursions * r;
            for (x = 2 * v.getBrushSize(); x >= 0; --x) {
                for (y = 2 * v.getBrushSize(); y >= 0; --y) {
                    tempsplat[x][y] = splat[x][y];
                    int growcheck = 0;
                    if (splat[x][y] == 0) {
                        if (x != 0 && splat[x - 1][y] == 1) {
                            ++growcheck;
                        }
                        if (y != 0 && splat[x][y - 1] == 1) {
                            ++growcheck;
                        }
                        if (x != 2 * v.getBrushSize() && splat[x + 1][y] == 1) {
                            ++growcheck;
                        }
                        if (y != 2 * v.getBrushSize() && splat[x][y + 1] == 1) {
                            ++growcheck;
                        }
                    }
                    if (growcheck < true || this.generator.nextInt(10000) > this.growPercent) continue;
                    tempsplat[x][y] = 1;
                }
            }
            for (x = 2 * v.getBrushSize(); x >= 0; --x) {
                for (y = 2 * v.getBrushSize(); y >= 0; --y) {
                    splat[x][y] = tempsplat[x][y];
                }
            }
        }
        this.growPercent = gref;
        int[][] memory = new int[v.getBrushSize() * 2 + 1][v.getBrushSize() * 2 + 1];
        double brushSizeSquared = Math.pow((double)v.getBrushSize() + 0.5, 2.0);
        for (int z = v.getBrushSize(); z >= -v.getBrushSize(); --z) {
            for (int x = v.getBrushSize(); x >= -v.getBrushSize(); --x) {
                block12: for (int y = this.getTargetBlock().getY(); y > 0; --y) {
                    int d;
                    int depth;
                    if (memory[x + v.getBrushSize()][z + v.getBrushSize()] == 1 || !(Math.pow(x, 2.0) + Math.pow(z, 2.0) <= brushSizeSquared) || splat[x + v.getBrushSize()][z + v.getBrushSize()] != 1 || this.getBlockIdAt(this.getTargetBlock().getX() + x, y - 1, this.getTargetBlock().getZ() + z) == 0 || this.getBlockIdAt(this.getTargetBlock().getX() + x, y + 1, this.getTargetBlock().getZ() + z) != 0) continue;
                    if (!this.allBlocks) {
                        switch (this.getBlockIdAt(this.getTargetBlock().getX() + x, y, this.getTargetBlock().getZ() + z)) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 12: 
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 24: 
                            case 48: 
                            case 49: 
                            case 78: 
                            case 82: {
                                depth = this.randomizeHeight ? this.generator.nextInt(this.depth) : this.depth;
                                for (d = 1; d < depth + 1; ++d) {
                                    this.current.perform(this.clampY(this.getTargetBlock().getX() + x, y + d + this.yOffset, this.getTargetBlock().getZ() + z));
                                    memory[x + v.getBrushSize()][z + v.getBrushSize()] = 1;
                                }
                                continue block12;
                            }
                        }
                        continue;
                    }
                    depth = this.randomizeHeight ? this.generator.nextInt(this.depth) : this.depth;
                    for (d = 1; d < depth + 1; ++d) {
                        this.current.perform(this.clampY(this.getTargetBlock().getX() + x, y + d + this.yOffset, this.getTargetBlock().getZ() + z));
                        memory[x + v.getBrushSize()][z + v.getBrushSize()] = 1;
                    }
                }
            }
        }
        v.owner().storeUndo(this.current.getUndo());
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.sOverlay(v);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.soverlayTwo(v);
    }

    @Override
    public final void info(Message vm) {
        if (this.seedPercent < 1 || this.seedPercent > 9999) {
            this.seedPercent = 1000;
        }
        if (this.growPercent < 1 || this.growPercent > 9999) {
            this.growPercent = 1000;
        }
        if (this.splatterRecursions < 1 || this.splatterRecursions > 10) {
            this.splatterRecursions = 3;
        }
        vm.brushName(this.getName());
        vm.size();
        vm.custom(ChatColor.BLUE + "Seed percent set to: " + this.seedPercent / 100 + "%");
        vm.custom(ChatColor.BLUE + "Growth percent set to: " + this.growPercent / 100 + "%");
        vm.custom(ChatColor.BLUE + "Recursions set to: " + this.splatterRecursions);
        vm.custom(ChatColor.BLUE + "Y-Offset set to: " + this.yOffset);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 1; i < par.length; ++i) {
            String parameter = par[i];
            try {
                double temp;
                if (parameter.equalsIgnoreCase("info")) {
                    v.sendMessage(ChatColor.GOLD + "Splatter Overlay brush parameters:");
                    v.sendMessage(ChatColor.AQUA + "d[number] (ex:  d3) How many blocks deep you want to replace from the surface.");
                    v.sendMessage(ChatColor.BLUE + "all (ex:  /b over all) Sets the brush to overlay over ALL materials, not just natural surface ones (will no longer ignore trees and buildings).  The parameter /some will set it back to default.");
                    v.sendMessage(ChatColor.AQUA + "/b sover s[int] -- set a seed percentage (1-9999). 100 = 1% Default is 1000");
                    v.sendMessage(ChatColor.AQUA + "/b sover g[int] -- set a growth percentage (1-9999).  Default is 1000");
                    v.sendMessage(ChatColor.AQUA + "/b sover r[int] -- set a recursion (1-10).  Default is 3");
                    return;
                }
                if (parameter.startsWith("d")) {
                    this.depth = Integer.parseInt(parameter.replace("d", ""));
                    v.sendMessage(ChatColor.AQUA + "Depth set to " + this.depth);
                    if (this.depth >= 1) continue;
                    this.depth = 1;
                    continue;
                }
                if (parameter.startsWith("all")) {
                    this.allBlocks = true;
                    v.sendMessage(ChatColor.BLUE + "Will overlay over any block." + this.depth);
                    continue;
                }
                if (parameter.startsWith("some")) {
                    this.allBlocks = false;
                    v.sendMessage(ChatColor.BLUE + "Will overlay only natural block types." + this.depth);
                    continue;
                }
                if (par[i].startsWith("s")) {
                    temp = Integer.parseInt(parameter.replace("s", ""));
                    if (temp >= 1.0 && temp <= 9999.0) {
                        v.sendMessage(ChatColor.AQUA + "Seed percent set to: " + temp / 100.0 + "%");
                        this.seedPercent = (int)temp;
                        continue;
                    }
                    v.sendMessage(ChatColor.RED + "Seed percent must be an integer 1-9999!");
                    continue;
                }
                if (parameter.startsWith("g")) {
                    temp = Integer.parseInt(parameter.replace("g", ""));
                    if (temp >= 1.0 && temp <= 9999.0) {
                        v.sendMessage(ChatColor.AQUA + "Growth percent set to: " + temp / 100.0 + "%");
                        this.growPercent = (int)temp;
                        continue;
                    }
                    v.sendMessage(ChatColor.RED + "Growth percent must be an integer 1-9999!");
                    continue;
                }
                if (parameter.startsWith("randh")) {
                    this.randomizeHeight = !this.randomizeHeight;
                    v.sendMessage(ChatColor.RED + "RandomizeHeight set to: " + this.randomizeHeight);
                    continue;
                }
                if (parameter.startsWith("r")) {
                    int temp2 = Integer.parseInt(parameter.replace("r", ""));
                    if (temp2 >= 1 && temp2 <= 10) {
                        v.sendMessage(ChatColor.AQUA + "Recursions set to: " + temp2);
                        this.splatterRecursions = temp2;
                        continue;
                    }
                    v.sendMessage(ChatColor.RED + "Recursions must be an integer 1-10!");
                    continue;
                }
                if (parameter.startsWith("yoff")) {
                    int temp3 = Integer.parseInt(parameter.replace("yoff", ""));
                    if (temp3 >= 1 && temp3 <= 10) {
                        v.sendMessage(ChatColor.AQUA + "Y-Offset set to: " + temp3);
                        this.yOffset = temp3;
                        continue;
                    }
                    v.sendMessage(ChatColor.RED + "Recursions must be an integer 1-10!");
                    continue;
                }
                v.sendMessage(ChatColor.RED + "Invalid brush parameters! use the info parameter to display parameter info.");
                continue;
            }
            catch (Exception exception) {
                v.sendMessage(String.format("An error occured while processing parameter %s.", parameter));
            }
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.splatteroverlay";
    }
}

