/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.VoxelSniper;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.bukkit.ChatColor;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;

public class SignOverwriteBrush
extends Brush {
    private static final int MAX_SIGN_LINE_LENGTH = 15;
    private static final int NUM_SIGN_LINES = 4;
    private static final int SIGN_LINE_1 = 1;
    private static final int SIGN_LINE_2 = 2;
    private static final int SIGN_LINE_3 = 3;
    private static final int SIGN_LINE_4 = 4;
    private String[] signTextLines = new String[4];
    private boolean[] signLinesEnabled = new boolean[4];
    private boolean rangedMode = false;

    public SignOverwriteBrush() {
        this.setName("Sign Overwrite Brush");
        this.clearBuffer();
        this.resetStates();
    }

    private void setSignText(Sign sign) {
        for (int i = 0; i < this.signTextLines.length; ++i) {
            if (!this.signLinesEnabled[i]) continue;
            sign.setLine(i, this.signTextLines[i]);
        }
        sign.update();
    }

    private void setSingle(SnipeData v) {
        if (!(this.getTargetBlock().getState() instanceof Sign)) {
            v.sendMessage(ChatColor.RED + "Target block is not a sign.");
            return;
        }
        this.setSignText((Sign)this.getTargetBlock().getState());
    }

    private void setRanged(SnipeData v) {
        int minX = this.getTargetBlock().getX() - v.getBrushSize();
        int maxX = this.getTargetBlock().getX() + v.getBrushSize();
        int minY = this.getTargetBlock().getY() - v.getVoxelHeight();
        int maxY = this.getTargetBlock().getY() + v.getVoxelHeight();
        int minZ = this.getTargetBlock().getZ() - v.getBrushSize();
        int maxZ = this.getTargetBlock().getZ() + v.getBrushSize();
        boolean signFound = false;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState blockState = this.getWorld().getBlockAt(x, y, z).getState();
                    if (!(blockState instanceof Sign)) continue;
                    this.setSignText((Sign)blockState);
                    signFound = true;
                }
            }
        }
        if (!signFound) {
            v.sendMessage(ChatColor.RED + "Did not found any sign in selection box.");
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        if (this.rangedMode) {
            this.setRanged(v);
        } else {
            this.setSingle(v);
        }
    }

    @Override
    protected final void powder(SnipeData v) {
        if (this.getTargetBlock().getState() instanceof Sign) {
            Sign sign = (Sign)this.getTargetBlock().getState();
            for (int i = 0; i < this.signTextLines.length; ++i) {
                if (!this.signLinesEnabled[i]) continue;
                this.signTextLines[i] = sign.getLine(i);
            }
            this.displayBuffer(v);
        } else {
            v.sendMessage(ChatColor.RED + "Target block is not a sign.");
        }
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        boolean textChanged = false;
        for (int i = 0; i < par.length; ++i) {
            String parameter = par[i];
            try {
                String fileName;
                if (parameter.equalsIgnoreCase("info")) {
                    v.sendMessage(ChatColor.AQUA + "Sign Overwrite Brush Powder/Arrow:");
                    v.sendMessage(ChatColor.BLUE + "The arrow writes the internal line buffer to the tearget sign.");
                    v.sendMessage(ChatColor.BLUE + "The powder reads the text of the target sign into the internal buffer.");
                    v.sendMessage(ChatColor.AQUA + "Sign Overwrite Brush Parameters:");
                    v.sendMessage(ChatColor.GREEN + "-1[:(enabled|disabled)] ... " + ChatColor.BLUE + "-- Sets the text of the first sign line. (e.g. -1 Blah Blah)");
                    v.sendMessage(ChatColor.GREEN + "-2[:(enabled|disabled)] ... " + ChatColor.BLUE + "-- Sets the text of the second sign line. (e.g. -2 Blah Blah)");
                    v.sendMessage(ChatColor.GREEN + "-3[:(enabled|disabled)] ... " + ChatColor.BLUE + "-- Sets the text of the third sign line. (e.g. -3 Blah Blah)");
                    v.sendMessage(ChatColor.GREEN + "-4[:(enabled|disabled)] ... " + ChatColor.BLUE + "-- Sets the text of the fourth sign line. (e.g. -4 Blah Blah)");
                    v.sendMessage(ChatColor.GREEN + "-clear " + ChatColor.BLUE + "-- Clears the line buffer. (Alias: -c)");
                    v.sendMessage(ChatColor.GREEN + "-clearall " + ChatColor.BLUE + "-- Clears the line buffer and sets all lines back to enabled. (Alias: -ca)");
                    v.sendMessage(ChatColor.GREEN + "-multiple [on|off] " + ChatColor.BLUE + "-- Enables or disables ranged mode. (Alias: -m) (see Wiki for more information)");
                    v.sendMessage(ChatColor.GREEN + "-save (name) " + ChatColor.BLUE + "-- Save you buffer to a file named [name]. (Alias: -s)");
                    v.sendMessage(ChatColor.GREEN + "-open (name) " + ChatColor.BLUE + "-- Loads a buffer from a file named [name]. (Alias: -o)");
                    continue;
                }
                if (parameter.startsWith("-1")) {
                    textChanged = true;
                    i = this.parseSignLineFromParam(par, 1, v, i);
                    continue;
                }
                if (parameter.startsWith("-2")) {
                    textChanged = true;
                    i = this.parseSignLineFromParam(par, 2, v, i);
                    continue;
                }
                if (parameter.startsWith("-3")) {
                    textChanged = true;
                    i = this.parseSignLineFromParam(par, 3, v, i);
                    continue;
                }
                if (parameter.startsWith("-4")) {
                    textChanged = true;
                    i = this.parseSignLineFromParam(par, 4, v, i);
                    continue;
                }
                if (parameter.equalsIgnoreCase("-clear") || parameter.equalsIgnoreCase("-c")) {
                    this.clearBuffer();
                    v.sendMessage(ChatColor.BLUE + "Internal text buffer cleard.");
                    continue;
                }
                if (parameter.equalsIgnoreCase("-clearall") || parameter.equalsIgnoreCase("-ca")) {
                    this.clearBuffer();
                    this.resetStates();
                    v.sendMessage(ChatColor.BLUE + "Internal text buffer cleard and states back to enabled.");
                    continue;
                }
                if (parameter.equalsIgnoreCase("-multiple") || parameter.equalsIgnoreCase("-m")) {
                    if (i + 1 >= par.length) {
                        v.sendMessage(ChatColor.RED + String.format("Missing parameter after %s.", parameter));
                        continue;
                    }
                    this.rangedMode = par[++i].equalsIgnoreCase("on") || par[++i].equalsIgnoreCase("yes");
                    v.sendMessage(ChatColor.BLUE + String.format("Ranged mode is %s", ChatColor.GREEN + (this.rangedMode ? "enabled" : "disabled")));
                    if (!this.rangedMode) continue;
                    v.sendMessage(ChatColor.GREEN + "Brush size set to " + ChatColor.RED + v.getBrushSize());
                    v.sendMessage(ChatColor.AQUA + "Brush height set to " + ChatColor.RED + v.getVoxelHeight());
                    continue;
                }
                if (parameter.equalsIgnoreCase("-save") || parameter.equalsIgnoreCase("-s")) {
                    if (i + 1 >= par.length) {
                        v.sendMessage(ChatColor.RED + String.format("Missing parameter after %s.", parameter));
                        continue;
                    }
                    fileName = par[++i];
                    this.saveBufferToFile(fileName, v);
                    continue;
                }
                if (!parameter.equalsIgnoreCase("-open") && !parameter.equalsIgnoreCase("-o")) continue;
                if (i + 1 >= par.length) {
                    v.sendMessage(ChatColor.RED + String.format("Missing parameter after %s.", parameter));
                    continue;
                }
                fileName = par[++i];
                this.loadBufferFromFile(fileName, "", v);
                textChanged = true;
                continue;
            }
            catch (Exception exception) {
                v.sendMessage(ChatColor.RED + String.format("Error while parsing parameter %s", parameter));
                exception.printStackTrace();
            }
        }
        if (textChanged) {
            this.displayBuffer(v);
        }
    }

    private int parseSignLineFromParam(String[] params, int lineNumber, SnipeData v, int i) {
        int lineIndex = lineNumber - 1;
        String parameter = params[i];
        boolean statusSet = false;
        if (parameter.contains(":")) {
            this.signLinesEnabled[lineIndex] = parameter.substring(parameter.indexOf(":")).equalsIgnoreCase(":enabled");
            v.sendMessage(ChatColor.BLUE + "Line " + lineNumber + " is " + ChatColor.GREEN + (this.signLinesEnabled[lineIndex] ? "enabled" : "disabled"));
            statusSet = true;
        }
        if (i + 1 >= params.length) {
            if (statusSet) {
                return i;
            }
            v.sendMessage(ChatColor.RED + "Warning: No text after -" + lineNumber + ". Setting buffer text to \"\" (empty string)");
            this.signTextLines[lineIndex] = "";
            return i;
        }
        String newText = "";
        ++i;
        while (i < params.length) {
            String currentParameter = params[i];
            if (currentParameter.startsWith("-")) {
                --i;
                break;
            }
            newText = newText + currentParameter + " ";
            ++i;
        }
        if (!(newText = ChatColor.translateAlternateColorCodes((char)'&', (String)newText)).isEmpty() && newText.endsWith(" ")) {
            newText = newText.substring(0, newText.length() - 1);
        } else if (newText.isEmpty()) {
            if (statusSet) {
                return i;
            }
            v.sendMessage(ChatColor.RED + "Warning: No text after -" + lineNumber + ". Setting buffer text to \"\" (empty string)");
        }
        if (newText.length() > 15) {
            v.sendMessage(ChatColor.RED + "Warning: Text on line " + lineNumber + " exceeds the maximum line length of " + 15 + " characters. Your text will be cut.");
            newText = newText.substring(0, 15);
        }
        this.signTextLines[lineIndex] = newText;
        return i;
    }

    private void displayBuffer(SnipeData v) {
        v.sendMessage(ChatColor.BLUE + "Buffer text set to: ");
        for (int i = 0; i < this.signTextLines.length; ++i) {
            v.sendMessage((this.signLinesEnabled[i] ? ChatColor.GREEN + "(E): " : ChatColor.RED + "(D): ") + ChatColor.BLACK + this.signTextLines[i]);
        }
    }

    private void saveBufferToFile(String fileName, SnipeData v) {
        File store = new File(VoxelSniper.getInstance().getDataFolder() + "/" + fileName + ".vsign");
        if (store.exists()) {
            v.sendMessage("This file already exists.");
            return;
        }
        try {
            store.createNewFile();
            FileWriter outFile = new FileWriter(store);
            BufferedWriter outStream = new BufferedWriter(outFile);
            for (int i = 0; i < this.signTextLines.length; ++i) {
                outStream.write(String.valueOf(this.signLinesEnabled[i]) + "\n");
                outStream.write(this.signTextLines[i] + "\n");
            }
            outStream.close();
            outFile.close();
            v.sendMessage(ChatColor.BLUE + "File saved successfully.");
        }
        catch (IOException exception) {
            v.sendMessage(ChatColor.RED + "Failed to save file. " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void loadBufferFromFile(String fileName, String userDomain, SnipeData v) {
        File store = new File(VoxelSniper.getInstance().getDataFolder() + "/" + fileName + ".vsign");
        if (!store.exists()) {
            v.sendMessage("This file does not exist.");
            return;
        }
        try {
            FileReader inFile = new FileReader(store);
            BufferedReader inStream = new BufferedReader(inFile);
            for (int i = 0; i < this.signTextLines.length; ++i) {
                this.signLinesEnabled[i] = Boolean.valueOf(inStream.readLine());
                this.signTextLines[i] = inStream.readLine();
            }
            inStream.close();
            inFile.close();
            v.sendMessage(ChatColor.BLUE + "File loaded successfully.");
        }
        catch (IOException exception) {
            v.sendMessage(ChatColor.RED + "Failed to load file. " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void clearBuffer() {
        for (int i = 0; i < this.signTextLines.length; ++i) {
            this.signTextLines[i] = "";
        }
    }

    private void resetStates() {
        for (int i = 0; i < this.signLinesEnabled.length; ++i) {
            this.signLinesEnabled[i] = true;
        }
    }

    @Override
    public final void info(Message vm) {
        vm.brushName("Sign Overwrite Brush");
        vm.custom(ChatColor.BLUE + "Buffer text: ");
        for (int i = 0; i < this.signTextLines.length; ++i) {
            vm.custom((this.signLinesEnabled[i] ? ChatColor.GREEN + "(E): " : ChatColor.RED + "(D): ") + ChatColor.BLACK + this.signTextLines[i]);
        }
        vm.custom(ChatColor.BLUE + String.format("Ranged mode is %s", ChatColor.GREEN + (this.rangedMode ? "enabled" : "disabled")));
        if (this.rangedMode) {
            vm.size();
            vm.height();
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.signoverwrite";
    }
}

