/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;

public class ShellSetBrush
extends Brush {
    private static final int MAX_SIZE = 5000000;
    private Block block = null;

    public ShellSetBrush() {
        this.setName("Shell Set");
    }

    private boolean set(Block bl, SnipeData v) {
        int highZ;
        if (this.block == null) {
            this.block = bl;
            return true;
        }
        if (!this.block.getWorld().getName().equals(bl.getWorld().getName())) {
            v.sendMessage(ChatColor.RED + "You selected points in different worlds!");
            this.block = null;
            return true;
        }
        int lowX = this.block.getX() <= bl.getX() ? this.block.getX() : bl.getX();
        int lowY = this.block.getY() <= bl.getY() ? this.block.getY() : bl.getY();
        int lowZ = this.block.getZ() <= bl.getZ() ? this.block.getZ() : bl.getZ();
        int highX = this.block.getX() >= bl.getX() ? this.block.getX() : bl.getX();
        int highY = this.block.getY() >= bl.getY() ? this.block.getY() : bl.getY();
        int n = highZ = this.block.getZ() >= bl.getZ() ? this.block.getZ() : bl.getZ();
        if (Math.abs(highX - lowX) * Math.abs(highZ - lowZ) * Math.abs(highY - lowY) > 5000000) {
            v.sendMessage(ChatColor.RED + "Selection size above hardcoded limit, please use a smaller selection.");
        } else {
            ArrayList<Block> blocks = new ArrayList<Block>(Math.abs(highX - lowX) * Math.abs(highZ - lowZ) * Math.abs(highY - lowY) / 2);
            for (int y = lowY; y <= highY; ++y) {
                for (int x = lowX; x <= highX; ++x) {
                    for (int z = lowZ; z <= highZ; ++z) {
                        if (this.getWorld().getBlockTypeIdAt(x, y, z) == v.getReplaceId() || this.getWorld().getBlockTypeIdAt(x + 1, y, z) == v.getReplaceId() || this.getWorld().getBlockTypeIdAt(x - 1, y, z) == v.getReplaceId() || this.getWorld().getBlockTypeIdAt(x, y, z + 1) == v.getReplaceId() || this.getWorld().getBlockTypeIdAt(x, y, z - 1) == v.getReplaceId() || this.getWorld().getBlockTypeIdAt(x, y + 1, z) == v.getReplaceId() || this.getWorld().getBlockTypeIdAt(x, y - 1, z) == v.getReplaceId()) continue;
                        blocks.add(this.getWorld().getBlockAt(x, y, z));
                    }
                }
            }
            Undo undo = new Undo();
            for (Block currentBlock : blocks) {
                if (currentBlock.getTypeId() == v.getVoxelId()) continue;
                undo.put(currentBlock);
                currentBlock.setTypeId(v.getVoxelId());
            }
            v.owner().storeUndo(undo);
            v.sendMessage(ChatColor.AQUA + "Shell complete.");
        }
        this.block = null;
        return false;
    }

    @Override
    protected final void arrow(SnipeData v) {
        if (this.set(this.getTargetBlock(), v)) {
            v.owner().getPlayer().sendMessage(ChatColor.GRAY + "Point one");
        }
    }

    @Override
    protected final void powder(SnipeData v) {
        if (this.set(this.getLastBlock(), v)) {
            v.owner().getPlayer().sendMessage(ChatColor.GRAY + "Point one");
        }
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.voxel();
        vm.replace();
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.shellset";
    }
}

