/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import com.thevoxelbox.voxelsniper.util.BlockWrapper;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;

public class Rot3DBrush
extends Brush {
    private final int mode = 0;
    private int bSize;
    private int brushSize;
    private BlockWrapper[][][] snap;
    private double seYaw;
    private double sePitch;
    private double seRoll;

    public Rot3DBrush() {
        this.setName("3D Rotation");
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.brushMessage("Rotates Yaw (XZ), then Pitch(XY), then Roll(ZY), in order.");
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 1; i < par.length; ++i) {
            String parameter = par[i];
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(ChatColor.GOLD + "Rotate brush Parameters:");
                v.sendMessage(ChatColor.AQUA + "p[0-359] -- set degrees of pitch rotation (rotation about the Z axis).");
                v.sendMessage(ChatColor.BLUE + "r[0-359] -- set degrees of roll rotation (rotation about the X axis).");
                v.sendMessage(ChatColor.LIGHT_PURPLE + "y[0-359] -- set degrees of yaw rotation (Rotation about the Y axis).");
                return;
            }
            if (parameter.startsWith("p")) {
                this.sePitch = Math.toRadians(Double.parseDouble(parameter.replace("p", "")));
                v.sendMessage(ChatColor.AQUA + "Around Z-axis degrees set to " + this.sePitch);
                if (!(this.sePitch < 0.0) && !(this.sePitch > 359.0)) continue;
                v.sendMessage(ChatColor.RED + "Invalid brush parameters! Angles must be from 1-359");
                continue;
            }
            if (parameter.startsWith("r")) {
                this.seRoll = Math.toRadians(Double.parseDouble(parameter.replace("r", "")));
                v.sendMessage(ChatColor.AQUA + "Around X-axis degrees set to " + this.seRoll);
                if (!(this.seRoll < 0.0) && !(this.seRoll > 359.0)) continue;
                v.sendMessage(ChatColor.RED + "Invalid brush parameters! Angles must be from 1-359");
                continue;
            }
            if (!parameter.startsWith("y")) continue;
            this.seYaw = Math.toRadians(Double.parseDouble(parameter.replace("y", "")));
            v.sendMessage(ChatColor.AQUA + "Around Y-axis degrees set to " + this.seYaw);
            if (!(this.seYaw < 0.0) && !(this.seYaw > 359.0)) continue;
            v.sendMessage(ChatColor.RED + "Invalid brush parameters! Angles must be from 1-359");
        }
    }

    private void getMatrix() {
        double brushSizeSquared = Math.pow((double)this.bSize + 0.5, 2.0);
        this.brushSize = this.bSize * 2 + 1;
        this.snap = new BlockWrapper[this.brushSize][this.brushSize][this.brushSize];
        int sx = this.getTargetBlock().getX() - this.bSize;
        int sz = this.getTargetBlock().getZ() - this.bSize;
        for (int x = 0; x < this.snap.length; ++x) {
            double xSquared = Math.pow(x - this.bSize, 2.0);
            sz = this.getTargetBlock().getZ() - this.bSize;
            for (int z = 0; z < this.snap.length; ++z) {
                double zSquared = Math.pow(z - this.bSize, 2.0);
                sz = this.getTargetBlock().getY() - this.bSize;
                for (int y = 0; y < this.snap.length; ++y) {
                    if (!(xSquared + zSquared + Math.pow(y - this.bSize, 2.0) <= brushSizeSquared)) continue;
                    Block block = this.clampY(sx, sz, sz);
                    this.snap[x][y][z] = new BlockWrapper(block);
                    block.setTypeId(0);
                    ++sz;
                }
                ++sz;
            }
            ++sx;
        }
    }

    private void rotate(SnipeData v) {
        int z;
        int x;
        double brushSizeSquared = Math.pow((double)this.bSize + 0.5, 2.0);
        double cosYaw = Math.cos(this.seYaw);
        double sinYaw = Math.sin(this.seYaw);
        double cosPitch = Math.cos(this.sePitch);
        double sinPitch = Math.sin(this.sePitch);
        double cosRoll = Math.cos(this.seRoll);
        double sinRoll = Math.sin(this.seRoll);
        boolean[][][] doNotFill = new boolean[this.snap.length][this.snap.length][this.snap.length];
        Undo undo = new Undo();
        for (x = 0; x < this.snap.length; ++x) {
            int xx = x - this.bSize;
            double xSquared = Math.pow(xx, 2.0);
            for (z = 0; z < this.snap.length; ++z) {
                int zz = z - this.bSize;
                double zSquared = Math.pow(zz, 2.0);
                double newxzX = (double)xx * cosYaw - (double)zz * sinYaw;
                double newxzZ = (double)xx * sinYaw + (double)zz * cosYaw;
                for (int y = 0; y < this.snap.length; ++y) {
                    int yy = y - this.bSize;
                    if (!(xSquared + zSquared + Math.pow(yy, 2.0) <= brushSizeSquared)) continue;
                    undo.put(this.clampY(this.getTargetBlock().getX() + xx, this.getTargetBlock().getY() + yy, this.getTargetBlock().getZ() + zz));
                    double newxyX = newxzX * cosPitch - (double)yy * sinPitch;
                    double newxyY = newxzX * sinPitch + (double)yy * cosPitch;
                    double newyzY = newxyY * cosRoll - newxzZ * sinRoll;
                    double newyzZ = newxyY * sinRoll + newxzZ * cosRoll;
                    doNotFill[(int)newxyX + this.bSize][(int)newyzY + this.bSize][(int)newyzZ + this.bSize] = true;
                    BlockWrapper block = this.snap[x][y][z];
                    if (block.getId() == 0) continue;
                    this.setBlockIdAndDataAt(this.getTargetBlock().getX() + (int)newxyX, this.getTargetBlock().getY() + (int)newyzY, this.getTargetBlock().getZ() + (int)newyzZ, block.getId(), block.getData());
                }
            }
        }
        for (x = 0; x < this.snap.length; ++x) {
            double xSquared = Math.pow(x - this.bSize, 2.0);
            int fx = x + this.getTargetBlock().getX() - this.bSize;
            for (z = 0; z < this.snap.length; ++z) {
                double zSquared = Math.pow(z - this.bSize, 2.0);
                int fz = z + this.getTargetBlock().getZ() - this.bSize;
                for (int y = 0; y < this.snap.length; ++y) {
                    byte winnerData;
                    int winner;
                    if (!(xSquared + zSquared + Math.pow(y - this.bSize, 2.0) <= brushSizeSquared) || doNotFill[x][y][z]) continue;
                    int fy = y + this.getTargetBlock().getY() - this.bSize;
                    int a = this.getBlockIdAt(fx + 1, fy, fz);
                    byte aData = this.getBlockDataAt(fx + 1, fy, fz);
                    int d = this.getBlockIdAt(fx - 1, fy, fz);
                    byte dData = this.getBlockDataAt(fx - 1, fy, fz);
                    int c = this.getBlockIdAt(fx, fy, fz + 1);
                    int b = this.getBlockIdAt(fx, fy, fz - 1);
                    byte bData = this.getBlockDataAt(fx, fy, fz - 1);
                    if (a == b || a == c || a == d) {
                        winner = a;
                        winnerData = aData;
                    } else if (b == d || c == d) {
                        winner = d;
                        winnerData = dData;
                    } else {
                        winner = b;
                        winnerData = bData;
                    }
                    this.setBlockIdAndDataAt(fx, fy, fz, winner, winnerData);
                }
            }
        }
        v.owner().storeUndo(undo);
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.bSize = v.getBrushSize();
        switch (this.mode) {
            case 0: {
                this.getMatrix();
                this.rotate(v);
                break;
            }
            default: {
                v.owner().getPlayer().sendMessage(ChatColor.RED + "Something went wrong.");
            }
        }
    }

    @Override
    protected final void powder(SnipeData v) {
        this.bSize = v.getBrushSize();
        switch (this.mode) {
            case 0: {
                this.getMatrix();
                this.rotate(v);
                break;
            }
            default: {
                v.owner().getPlayer().sendMessage(ChatColor.RED + "Something went wrong.");
            }
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.rot3d";
    }
}

