/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.Brush;
import com.thevoxelbox.voxelsniper.util.BlockWrapper;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;

public class Rot2DBrush
extends Brush {
    private int mode = 0;
    private int bSize;
    private int brushSize;
    private BlockWrapper[][][] snap;
    private double se;

    public Rot2DBrush() {
        this.setName("2D Rotation");
    }

    private void getMatrix() {
        this.brushSize = this.bSize * 2 + 1;
        this.snap = new BlockWrapper[this.brushSize][this.brushSize][this.brushSize];
        double brushSizeSquared = Math.pow((double)this.bSize + 0.5, 2.0);
        int sx = this.getTargetBlock().getX() - this.bSize;
        int sy = this.getTargetBlock().getY() - this.bSize;
        int sz = this.getTargetBlock().getZ() - this.bSize;
        for (int x = 0; x < this.snap.length; ++x) {
            sz = this.getTargetBlock().getZ() - this.bSize;
            double xSquared = Math.pow(x - this.bSize, 2.0);
            for (int y = 0; y < this.snap.length; ++y) {
                sy = this.getTargetBlock().getY() - this.bSize;
                if (xSquared + Math.pow(y - this.bSize, 2.0) <= brushSizeSquared) {
                    for (int z = 0; z < this.snap.length; ++z) {
                        Block block = this.clampY(sx, sy, sz);
                        this.snap[x][z][y] = new BlockWrapper(block);
                        block.setTypeId(0);
                        ++sy;
                    }
                }
                ++sz;
            }
            ++sx;
        }
    }

    private void rotate(SnipeData v) {
        int x;
        double brushSiyeSquared = Math.pow((double)this.bSize + 0.5, 2.0);
        double cos = Math.cos(this.se);
        double sin = Math.sin(this.se);
        boolean[][] doNotFill = new boolean[this.snap.length][this.snap.length];
        for (x = 0; x < this.snap.length; ++x) {
            int xx = x - this.bSize;
            double xSquared = Math.pow(xx, 2.0);
            for (int y = 0; y < this.snap.length; ++y) {
                int zz = y - this.bSize;
                if (!(xSquared + Math.pow(zz, 2.0) <= brushSiyeSquared)) continue;
                double newX = (double)xx * cos - (double)zz * sin;
                double newZ = (double)xx * sin + (double)zz * cos;
                doNotFill[(int)newX + this.bSize][(int)newZ + this.bSize] = true;
                for (int currentY = 0; currentY < this.snap.length; ++currentY) {
                    int yy = currentY - this.bSize;
                    BlockWrapper block = this.snap[x][currentY][y];
                    if (block.getId() == 0) continue;
                    this.setBlockIdAndDataAt(this.getTargetBlock().getX() + (int)newX, this.getTargetBlock().getY() + yy, this.getTargetBlock().getZ() + (int)newZ, block.getId(), block.getData());
                }
            }
        }
        for (x = 0; x < this.snap.length; ++x) {
            double xSquared = Math.pow(x - this.bSize, 2.0);
            int fx = x + this.getTargetBlock().getX() - this.bSize;
            for (int z = 0; z < this.snap.length; ++z) {
                if (!(xSquared + Math.pow(z - this.bSize, 2.0) <= brushSiyeSquared)) continue;
                int fz = z + this.getTargetBlock().getZ() - this.bSize;
                if (doNotFill[x][z]) continue;
                for (int y = 0; y < this.snap.length; ++y) {
                    byte winnerData;
                    int winner;
                    int fy = y + this.getTargetBlock().getY() - this.bSize;
                    int a = this.getBlockIdAt(fx + 1, fy, fz);
                    byte aData = this.getBlockDataAt(fx + 1, fy, fz);
                    int d = this.getBlockIdAt(fx - 1, fy, fz);
                    byte dData = this.getBlockDataAt(fx - 1, fy, fz);
                    int c = this.getBlockIdAt(fx, fy, fz + 1);
                    int b = this.getBlockIdAt(fx, fy, fz - 1);
                    byte bData = this.getBlockDataAt(fx, fy, fz - 1);
                    if (a == b || a == c || a == d) {
                        winner = a;
                        winnerData = aData;
                    } else if (b == d || c == d) {
                        winner = d;
                        winnerData = dData;
                    } else {
                        winner = b;
                        winnerData = bData;
                    }
                    this.setBlockIdAndDataAt(fx, fy, fz, winner, winnerData);
                }
            }
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.bSize = v.getBrushSize();
        switch (this.mode) {
            case 0: {
                this.getMatrix();
                this.rotate(v);
                break;
            }
            default: {
                v.sendMessage(ChatColor.RED + "Something went wrong.");
            }
        }
    }

    @Override
    protected final void powder(SnipeData v) {
        this.bSize = v.getBrushSize();
        switch (this.mode) {
            case 0: {
                this.getMatrix();
                this.rotate(v);
                break;
            }
            default: {
                v.sendMessage(ChatColor.RED + "Something went wrong.");
            }
        }
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        this.se = Math.toRadians(Double.parseDouble(par[1]));
        v.sendMessage(ChatColor.GREEN + "Angle set to " + this.se);
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.rot2d";
    }
}

