/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.perform.PerformBrush;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class PunishBrush
extends PerformBrush {
    private static final int MAXIMAL_RANDOM_TELEPORTATION_RANGE = 400;
    private static final int TICKS_PER_SECOND = 20;
    private static final int INFINIPUNISH_SIZE = -3;
    private static final int DEFAULT_PUNISH_LEVEL = 10;
    private static final int DEFAULT_PUSNIH_DURATION = 60;
    private Punishment punishment = Punishment.FIRE;
    private int punishLevel = 10;
    private int punishDuration = 60;
    private boolean specificPlayer = false;
    private String punishPlayerName = "";
    private boolean hypnoAffectLandscape = false;
    private boolean hitsSelf = false;

    public PunishBrush() {
        this.setName("Punish");
    }

    private void applyPunishment(LivingEntity entity, SnipeData v) {
        switch (this.punishment) {
            case FIRE: {
                entity.setFireTicks(20 * this.punishDuration);
                break;
            }
            case LIGHTNING: {
                entity.getWorld().strikeLightning(entity.getLocation());
                break;
            }
            case BLINDNESS: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case DRUNK: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case SLOW: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case JUMP: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.JUMP, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case ABSORPTION: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case DAMAGE_RESISTANCE: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case FAST_DIGGING: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.FAST_DIGGING, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case FIRE_RESISTANCE: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case HEAL: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.HEAL, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case HEALTH_BOOST: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.HEALTH_BOOST, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case HUNGER: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case INCREASE_DAMAGE: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case INVISIBILITY: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case NIGHT_VISION: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case POISON: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case REGENERATION: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case SATURATION: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.SATURATION, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case SLOW_DIGGING: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_DIGGING, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case SPEED: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case WATER_BREATHING: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case WEAKNESS: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case WITHER: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case KILL: {
                entity.setHealth(0.0);
                break;
            }
            case RANDOMTP: {
                Random random = new Random();
                Location targetLocation = entity.getLocation();
                targetLocation.setX(targetLocation.getX() + (double)(random.nextInt(400) - 200));
                targetLocation.setZ(targetLocation.getZ() + (double)(random.nextInt(400) - 200));
                entity.teleport(targetLocation);
                break;
            }
            case ALL_POTION: {
                entity.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 20 * this.punishDuration, this.punishLevel), true);
                entity.addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, 20 * this.punishDuration, this.punishLevel), true);
                entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 20 * this.punishDuration, this.punishLevel), true);
                entity.addPotionEffect(new PotionEffect(PotionEffectType.JUMP, 20 * this.punishDuration, this.punishLevel), true);
                break;
            }
            case FORCE: {
                Vector playerVector = this.getTargetBlock().getLocation().toVector();
                Vector direction = entity.getLocation().toVector().clone();
                direction.subtract(playerVector);
                double length = direction.length();
                double stregth = (1.0 - length / (double)v.getBrushSize()) * (double)this.punishLevel;
                direction.normalize();
                direction.multiply(stregth);
                entity.setVelocity(direction);
                break;
            }
            case HYPNO: {
                if (!(entity instanceof Player)) break;
                Location location = entity.getLocation();
                Location target = location.clone();
                for (int z = this.punishLevel; z >= -this.punishLevel; --z) {
                    for (int x = this.punishLevel; x >= -this.punishLevel; --x) {
                        for (int y = this.punishLevel; y >= -this.punishLevel; --y) {
                            target.setX(location.getX() + (double)x);
                            target.setY(location.getY() + (double)y);
                            target.setZ(location.getZ() + (double)z);
                            if (this.hypnoAffectLandscape && target.getBlock().getType() == Material.AIR) continue;
                            target = location.clone();
                            target.add((double)x, (double)y, (double)z);
                            ((Player)entity).sendBlockChange(target, v.getVoxelId(), v.getData());
                        }
                    }
                }
                break;
            }
            default: {
                Bukkit.getLogger().warning("Could not determine the punishment of punish brush!");
            }
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        if (!v.owner().getPlayer().hasPermission("voxelsniper.punish")) {
            v.sendMessage("The server says no!");
            return;
        }
        this.punishDuration = v.getVoxelHeight();
        this.punishLevel = v.getcCen();
        if (this.specificPlayer) {
            Player punishedPlayer = Bukkit.getPlayer((String)this.punishPlayerName);
            if (punishedPlayer == null) {
                v.sendMessage("No player " + this.punishPlayerName + " found.");
                return;
            }
            this.applyPunishment((LivingEntity)punishedPlayer, v);
            return;
        }
        int brushSizeSquare = v.getBrushSize() * v.getBrushSize();
        Location targetLocation = new Location(v.getWorld(), (double)this.getTargetBlock().getX(), (double)this.getTargetBlock().getY(), (double)this.getTargetBlock().getZ());
        List entities = v.getWorld().getLivingEntities();
        int numPunishApps = 0;
        for (LivingEntity entity : entities) {
            if (v.owner().getPlayer() == entity && !this.hitsSelf) continue;
            if (v.getBrushSize() >= 0) {
                try {
                    if (!(entity.getLocation().distanceSquared(targetLocation) <= (double)brushSizeSquare)) continue;
                    ++numPunishApps;
                    this.applyPunishment(entity, v);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    v.sendMessage("An error occured.");
                    return;
                }
            }
            if (v.getBrushSize() != -3) continue;
            ++numPunishApps;
            this.applyPunishment(entity, v);
        }
        v.sendMessage(ChatColor.DARK_RED + "Punishment applied to " + numPunishApps + " living entities.");
    }

    @Override
    protected final void powder(SnipeData v) {
        if (!v.owner().getPlayer().hasPermission("voxelsniper.punish")) {
            v.sendMessage("The server says no!");
            return;
        }
        int brushSizeSquare = v.getBrushSize() * v.getBrushSize();
        Location targetLocation = new Location(v.getWorld(), (double)this.getTargetBlock().getX(), (double)this.getTargetBlock().getY(), (double)this.getTargetBlock().getZ());
        List entities = v.getWorld().getLivingEntities();
        for (LivingEntity entity : entities) {
            if (!(entity.getLocation().distanceSquared(targetLocation) < (double)brushSizeSquare)) continue;
            entity.setFireTicks(0);
            entity.removePotionEffect(PotionEffectType.BLINDNESS);
            entity.removePotionEffect(PotionEffectType.CONFUSION);
            entity.removePotionEffect(PotionEffectType.SLOW);
            entity.removePotionEffect(PotionEffectType.JUMP);
        }
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom(ChatColor.GREEN + "Punishment: " + this.punishment.toString());
        vm.size();
        vm.center();
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 1; i < par.length; ++i) {
            String parameter = par[i].toLowerCase();
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(ChatColor.GOLD + "Punish Brush Options:");
                v.sendMessage(ChatColor.AQUA + "Punishments can be set via /b p [punishment]");
                v.sendMessage(ChatColor.AQUA + "Punishment level can be set with /vc [level]");
                v.sendMessage(ChatColor.AQUA + "Punishment duration in seconds can be set with /vh [duration]");
                v.sendMessage(ChatColor.AQUA + "Parameter -toggleHypnoLandscape will make Hypno punishment only affect landscape.");
                v.sendMessage(ChatColor.AQUA + "Parameter -toggleSM [playername] will make punishbrush only affect that player.");
                v.sendMessage(ChatColor.AQUA + "Parameter -toggleSelf will toggle whether you get hit as well.");
                v.sendMessage(ChatColor.AQUA + "Available Punishment Options:");
                StringBuilder punishmentOptions = new StringBuilder();
                for (Punishment punishment : Punishment.values()) {
                    if (punishmentOptions.length() != 0) {
                        punishmentOptions.append(" | ");
                    }
                    punishmentOptions.append(punishment.name());
                }
                v.sendMessage(ChatColor.GOLD + punishmentOptions.toString());
                return;
            }
            if (parameter.equalsIgnoreCase("-toggleSM")) {
                boolean bl = this.specificPlayer = !this.specificPlayer;
                if (!this.specificPlayer) continue;
                try {
                    this.punishPlayerName = par[++i];
                }
                catch (IndexOutOfBoundsException exception) {
                    v.sendMessage(ChatColor.AQUA + "You have to specify a player name after -toggleSM if you want to turn the specific player feature on.");
                }
                continue;
            }
            if (parameter.equalsIgnoreCase("-toggleSelf")) {
                boolean bl = this.hitsSelf = !this.hitsSelf;
                if (this.hitsSelf) {
                    v.sendMessage(ChatColor.AQUA + "Your punishments will now affect you too!");
                    continue;
                }
                v.sendMessage(ChatColor.AQUA + "Your punishments will no longer affect you!");
                continue;
            }
            if (parameter.equalsIgnoreCase("-toggleHypnoLandscape")) {
                this.hypnoAffectLandscape = !this.hypnoAffectLandscape;
                continue;
            }
            try {
                this.punishment = Punishment.valueOf(parameter.toUpperCase());
                v.sendMessage(ChatColor.AQUA + this.punishment.name().toLowerCase() + " punishment selected.");
                continue;
            }
            catch (IllegalArgumentException exception) {
                v.sendMessage(ChatColor.AQUA + "No such Punishment.");
            }
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.punish";
    }

    private static enum Punishment {
        FIRE,
        LIGHTNING,
        BLINDNESS,
        DRUNK,
        KILL,
        RANDOMTP,
        ALL_POTION,
        SLOW,
        JUMP,
        ABSORPTION,
        DAMAGE_RESISTANCE,
        FAST_DIGGING,
        FIRE_RESISTANCE,
        HEAL,
        HEALTH_BOOST,
        HUNGER,
        INCREASE_DAMAGE,
        INVISIBILITY,
        NIGHT_VISION,
        POISON,
        REGENERATION,
        SATURATION,
        SLOW_DIGGING,
        SPEED,
        WATER_BREATHING,
        WEAKNESS,
        WITHER,
        FORCE,
        HYPNO;

    }
}

