/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class OceanBrush
extends Brush {
    private static final int WATER_LEVEL_DEFAULT = 62;
    private static final int WATER_LEVEL_MIN = 12;
    private static final int LOW_CUT_LEVEL = 12;
    private static final List<Material> EXCLUDED_MATERIALS = new LinkedList<Material>();
    private int waterLevel = 62;
    private boolean coverFloor = false;

    public OceanBrush() {
        this.setName("OCEANATOR 5000(tm)");
    }

    private int getHeight(int bx, int bz) {
        for (int y = this.getWorld().getHighestBlockYAt(bx, bz); y > 0; --y) {
            Material material = this.clampY(bx, y, bz).getType();
            if (EXCLUDED_MATERIALS.contains(material)) continue;
            return y;
        }
        return 0;
    }

    protected final void oceanator(SnipeData v, Undo undo) {
        World world = this.getWorld();
        int minX = (int)Math.floor(this.getTargetBlock().getX() - v.getBrushSize());
        int minZ = (int)Math.floor(this.getTargetBlock().getZ() - v.getBrushSize());
        int maxX = (int)Math.floor(this.getTargetBlock().getX() + v.getBrushSize());
        int maxZ = (int)Math.floor(this.getTargetBlock().getZ() + v.getBrushSize());
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                Block block;
                Block block2;
                int highestY;
                int y;
                int currentHeight = this.getHeight(x, z);
                int wLevelDiff = currentHeight - (this.waterLevel - 1);
                int newSeaFloorLevel = this.waterLevel - wLevelDiff >= 12 ? this.waterLevel - wLevelDiff : 12;
                for (y = highestY = this.getWorld().getHighestBlockYAt(x, z); y > newSeaFloorLevel; --y) {
                    block2 = world.getBlockAt(x, y, z);
                    if (block2.getType().equals((Object)Material.AIR)) continue;
                    undo.put(block2);
                    block2.setType(Material.AIR);
                }
                for (y = this.waterLevel; y > newSeaFloorLevel; --y) {
                    block2 = world.getBlockAt(x, y, z);
                    if (block2.getType().equals((Object)Material.STATIONARY_WATER)) continue;
                    if (!block2.getType().equals((Object)Material.AIR)) {
                        undo.put(block2);
                    }
                    block2.setType(Material.STATIONARY_WATER);
                }
                if (!this.coverFloor || newSeaFloorLevel >= this.waterLevel || (block = world.getBlockAt(x, newSeaFloorLevel, z)).getTypeId() == v.getVoxelId()) continue;
                undo.put(block);
                block.setTypeId(v.getVoxelId());
            }
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        Undo undo = new Undo();
        this.oceanator(v, undo);
        v.owner().storeUndo(undo);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.arrow(v);
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 0; i < par.length; ++i) {
            String parameter = par[i];
            try {
                if (parameter.equalsIgnoreCase("info")) {
                    v.sendMessage(ChatColor.BLUE + "Parameters:");
                    v.sendMessage(ChatColor.GREEN + "-wlevel #  " + ChatColor.BLUE + "--  Sets the water level (e.g. -wlevel 64)");
                    v.sendMessage(ChatColor.GREEN + "-cfloor [y|n]  " + ChatColor.BLUE + "--  Enables or disables sea floor cover (e.g. -cfloor y) (Cover material will be your voxel material)");
                    continue;
                }
                if (parameter.equalsIgnoreCase("-wlevel")) {
                    int temp;
                    if (i + 1 >= par.length) {
                        v.sendMessage(ChatColor.RED + "Missing parameter. Correct syntax: -wlevel [#] (e.g. -wlevel 64)");
                        continue;
                    }
                    if ((temp = Integer.parseInt(par[++i])) <= 12) {
                        v.sendMessage(ChatColor.RED + "Error: Your specified water level was below 12.");
                        continue;
                    }
                    this.waterLevel = temp - 1;
                    v.sendMessage(ChatColor.BLUE + "Water level set to " + ChatColor.GREEN + (this.waterLevel + 1));
                    continue;
                }
                if (!parameter.equalsIgnoreCase("-cfloor") && !parameter.equalsIgnoreCase("-coverfloor")) continue;
                if (i + 1 >= par.length) {
                    v.sendMessage(ChatColor.RED + "Missing parameter. Correct syntax: -cfloor [y|n] (e.g. -cfloor y)");
                    continue;
                }
                this.coverFloor = par[++i].equalsIgnoreCase("y");
                v.sendMessage(ChatColor.BLUE + String.format("Floor cover %s.", ChatColor.GREEN + (this.coverFloor ? "enabled" : "disabled")));
                continue;
            }
            catch (Exception exception) {
                v.sendMessage(ChatColor.RED + String.format("Error while parsing parameter: %s", parameter));
                exception.printStackTrace();
            }
        }
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom(ChatColor.BLUE + "Water level set to " + ChatColor.GREEN + (this.waterLevel + 1));
        vm.custom(ChatColor.BLUE + String.format("Floor cover %s.", ChatColor.GREEN + (this.coverFloor ? "enabled" : "disabled")));
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.ocean";
    }

    static {
        EXCLUDED_MATERIALS.add(Material.AIR);
        EXCLUDED_MATERIALS.add(Material.SAPLING);
        EXCLUDED_MATERIALS.add(Material.WATER);
        EXCLUDED_MATERIALS.add(Material.STATIONARY_WATER);
        EXCLUDED_MATERIALS.add(Material.LAVA);
        EXCLUDED_MATERIALS.add(Material.STATIONARY_LAVA);
        EXCLUDED_MATERIALS.add(Material.LOG);
        EXCLUDED_MATERIALS.add(Material.LEAVES);
        EXCLUDED_MATERIALS.add(Material.YELLOW_FLOWER);
        EXCLUDED_MATERIALS.add(Material.RED_ROSE);
        EXCLUDED_MATERIALS.add(Material.RED_MUSHROOM);
        EXCLUDED_MATERIALS.add(Material.BROWN_MUSHROOM);
        EXCLUDED_MATERIALS.add(Material.MELON_BLOCK);
        EXCLUDED_MATERIALS.add(Material.MELON_STEM);
        EXCLUDED_MATERIALS.add(Material.PUMPKIN);
        EXCLUDED_MATERIALS.add(Material.PUMPKIN_STEM);
        EXCLUDED_MATERIALS.add(Material.COCOA);
        EXCLUDED_MATERIALS.add(Material.SNOW);
        EXCLUDED_MATERIALS.add(Material.SNOW_BLOCK);
        EXCLUDED_MATERIALS.add(Material.ICE);
        EXCLUDED_MATERIALS.add(Material.SUGAR_CANE_BLOCK);
        EXCLUDED_MATERIALS.add(Material.LONG_GRASS);
        EXCLUDED_MATERIALS.add(Material.SNOW);
    }
}

