/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;

public class JockeyBrush
extends Brush {
    private static final int ENTITY_STACK_LIMIT = 50;
    private JockeyType jockeyType = JockeyType.NORMAL_ALL_ENTITIES;
    private Entity jockeyedEntity = null;

    public JockeyBrush() {
        this.setName("Jockey");
    }

    private void sitOn(SnipeData v) {
        Chunk targetChunk = this.getWorld().getChunkAt(this.getTargetBlock().getLocation());
        int targetChunkX = targetChunk.getX();
        int targetChunkZ = targetChunk.getZ();
        double range = Double.MAX_VALUE;
        Entity closest = null;
        for (int x = targetChunkX - 1; x <= targetChunkX + 1; ++x) {
            for (int y = targetChunkZ - 1; y <= targetChunkZ + 1; ++y) {
                for (Entity entity : this.getWorld().getChunkAt(x, y).getEntities()) {
                    Location entityLocation;
                    double entityDistance;
                    if (entity.getEntityId() == v.owner().getPlayer().getEntityId() || (this.jockeyType == JockeyType.NORMAL_PLAYER_ONLY || this.jockeyType == JockeyType.INVERSE_PLAYER_ONLY) && !(entity instanceof Player) || !((entityDistance = (entityLocation = entity.getLocation()).distance(v.owner().getPlayer().getLocation())) < range)) continue;
                    range = entityDistance;
                    closest = entity;
                }
            }
        }
        if (closest != null) {
            Player player = v.owner().getPlayer();
            PlayerTeleportEvent playerTeleportEvent = new PlayerTeleportEvent(player, player.getLocation(), closest.getLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
            Bukkit.getPluginManager().callEvent((Event)playerTeleportEvent);
            if (!playerTeleportEvent.isCancelled()) {
                if (this.jockeyType == JockeyType.INVERSE_PLAYER_ONLY || this.jockeyType == JockeyType.INVERSE_ALL_ENTITIES) {
                    player.setPassenger(closest);
                } else {
                    closest.setPassenger((Entity)player);
                    this.jockeyedEntity = closest;
                }
                v.sendMessage(ChatColor.GREEN + "You are now saddles on entity: " + closest.getEntityId());
            }
        } else {
            v.sendMessage(ChatColor.RED + "Could not find any entities");
        }
    }

    private void stack(SnipeData v) {
        int brushSizeDoubled = v.getBrushSize() * 2;
        List nearbyEntities = v.owner().getPlayer().getNearbyEntities((double)brushSizeDoubled, (double)brushSizeDoubled, (double)brushSizeDoubled);
        Player lastEntity = v.owner().getPlayer();
        int stackHeight = 0;
        for (Entity entity : nearbyEntities) {
            if (stackHeight < 50) {
                if (this.jockeyType == JockeyType.STACK_ALL_ENTITIES) {
                    lastEntity.setPassenger(entity);
                    lastEntity = entity;
                    ++stackHeight;
                    continue;
                }
                if (this.jockeyType == JockeyType.STACK_PLAYER_ONLY) {
                    if (!(entity instanceof Player)) continue;
                    lastEntity.setPassenger(entity);
                    lastEntity = entity;
                    ++stackHeight;
                    continue;
                }
                v.owner().getPlayer().sendMessage("You broke stack! :O");
                continue;
            }
            return;
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        if (this.jockeyType == JockeyType.STACK_ALL_ENTITIES || this.jockeyType == JockeyType.STACK_PLAYER_ONLY) {
            this.stack(v);
        } else {
            this.sitOn(v);
        }
    }

    @Override
    protected final void powder(SnipeData v) {
        if (this.jockeyType == JockeyType.INVERSE_PLAYER_ONLY || this.jockeyType == JockeyType.INVERSE_ALL_ENTITIES) {
            v.owner().getPlayer().eject();
            v.owner().getPlayer().sendMessage(ChatColor.GOLD + "The guy on top of you has been ejected!");
        } else if (this.jockeyedEntity != null) {
            this.jockeyedEntity.eject();
            this.jockeyedEntity = null;
            v.owner().getPlayer().sendMessage(ChatColor.GOLD + "You have been ejected!");
        }
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom("Current jockey mode: " + ChatColor.GREEN + this.jockeyType.toString());
        vm.custom(ChatColor.GREEN + "Help: " + ChatColor.AQUA + "http://www.voxelwiki.com/minecraft/Voxelsniper#The_Jockey_Brush");
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        boolean inverse = false;
        boolean playerOnly = false;
        boolean stack = false;
        try {
            for (String parameter : par) {
                if (parameter.startsWith("-i:")) {
                    inverse = parameter.endsWith("y");
                }
                if (parameter.startsWith("-po:")) {
                    playerOnly = parameter.endsWith("y");
                }
                if (!parameter.startsWith("-s:")) continue;
                stack = parameter.endsWith("y");
            }
            this.jockeyType = inverse ? (playerOnly ? JockeyType.INVERSE_PLAYER_ONLY : JockeyType.INVERSE_ALL_ENTITIES) : (stack ? (playerOnly ? JockeyType.STACK_PLAYER_ONLY : JockeyType.STACK_ALL_ENTITIES) : (playerOnly ? JockeyType.NORMAL_PLAYER_ONLY : JockeyType.NORMAL_ALL_ENTITIES));
            v.sendMessage("Current jockey mode: " + ChatColor.GREEN + this.jockeyType.toString());
        }
        catch (Exception exception) {
            v.sendMessage("Error while parsing your arguments.");
            exception.printStackTrace();
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.jockey";
    }

    private static enum JockeyType {
        NORMAL_ALL_ENTITIES("Normal (All)"),
        NORMAL_PLAYER_ONLY("Normal (Player only)"),
        INVERSE_ALL_ENTITIES("Inverse (All)"),
        INVERSE_PLAYER_ONLY("Inverse (Player only)"),
        STACK_ALL_ENTITIES("Stack (All)"),
        STACK_PLAYER_ONLY("Stack (Player only)");

        private String name;

        private JockeyType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

