/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.perform.PerformBrush;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public class JaggedLineBrush
extends PerformBrush {
    private static final Vector HALF_BLOCK_OFFSET = new Vector(0.5, 0.5, 0.5);
    private static int timesUsed = 0;
    private static final int RECURSION_MIN = 1;
    private static final int RECURSION_DEFAULT = 3;
    private static final int RECURSION_MAX = 10;
    private static final int SPREAD_DEFAULT = 3;
    private Random random = new Random();
    private Vector originCoords = null;
    private Vector targetCoords = new Vector();
    private int recursion = 3;
    private int spread = 3;

    public JaggedLineBrush() {
        this.setName("Jagged Line");
    }

    private void jaggedP(SnipeData v) {
        Vector originClone = this.originCoords.clone().add(HALF_BLOCK_OFFSET);
        Vector targetClone = this.targetCoords.clone().add(HALF_BLOCK_OFFSET);
        Vector direction = targetClone.clone().subtract(originClone);
        double length = this.targetCoords.distance(this.originCoords);
        if (length == 0.0) {
            this.current.perform(this.targetCoords.toLocation(this.getWorld()).getBlock());
        } else {
            BlockIterator iterator = new BlockIterator(this.getWorld(), originClone, direction, 0.0, NumberConversions.round((double)length));
            while (iterator.hasNext()) {
                Block block = iterator.next();
                for (int i = 0; i < this.recursion; ++i) {
                    this.current.perform(this.clampY(Math.round(block.getX() + this.random.nextInt(this.spread * 2) - this.spread), Math.round(block.getY() + this.random.nextInt(this.spread * 2) - this.spread), Math.round(block.getZ() + this.random.nextInt(this.spread * 2) - this.spread)));
                }
            }
        }
        v.owner().storeUndo(this.current.getUndo());
    }

    @Override
    public final void arrow(SnipeData v) {
        if (this.originCoords == null) {
            this.originCoords = new Vector();
        }
        this.originCoords = this.getTargetBlock().getLocation().toVector();
        v.sendMessage(ChatColor.DARK_PURPLE + "First point selected.");
    }

    @Override
    public final void powder(SnipeData v) {
        if (this.originCoords == null) {
            v.sendMessage(ChatColor.RED + "Warning: You did not select a first coordinate with the arrow");
        } else {
            this.targetCoords = this.getTargetBlock().getLocation().toVector();
            this.jaggedP(v);
        }
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.custom(ChatColor.GRAY + String.format("Recursion set to: %d", this.recursion));
        vm.custom(ChatColor.GRAY + String.format("Spread set to: %d", this.spread));
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (String parameter : par) {
            try {
                int temp;
                if (parameter.equalsIgnoreCase("info")) {
                    v.sendMessage(ChatColor.GOLD + "Jagged Line Brush instructions: Right click first point with the arrow. Right click with powder to draw a jagged line to set the second point.");
                    v.sendMessage(ChatColor.AQUA + "/b j r# - sets the number of recursions (default 3, must be 1-10)");
                    v.sendMessage(ChatColor.AQUA + "/b j s# - sets the spread (default 3, must be 1-10)");
                    return;
                }
                if (parameter.startsWith("r")) {
                    int temp2 = Integer.parseInt(parameter.substring(1));
                    if (temp2 >= 1 && temp2 <= 10) {
                        this.recursion = temp2;
                        v.sendMessage(ChatColor.GREEN + "Recursion set to: " + this.recursion);
                    } else {
                        v.sendMessage(ChatColor.RED + "ERROR: Recursion must be " + 1 + "-" + 10);
                    }
                    return;
                }
                if (!parameter.startsWith("s")) continue;
                this.spread = temp = Integer.parseInt(parameter.substring(1));
                v.sendMessage(ChatColor.GREEN + "Spread set to: " + this.spread);
            }
            catch (Exception exception) {
                v.sendMessage(ChatColor.RED + String.format("Exception while parsing parameter: %s", parameter));
                exception.printStackTrace();
            }
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.jaggedline";
    }
}

