/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.Brush;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;

public class EntityRemovalBrush
extends Brush {
    private final List<String> exemptions = new ArrayList<String>(3);

    public EntityRemovalBrush() {
        this.setName("Entity Removal");
        this.exemptions.add("org.bukkit.entity.Player");
        this.exemptions.add("org.bukkit.entity.Hanging");
        this.exemptions.add("org.bukkit.entity.NPC");
    }

    private void radialRemoval(SnipeData v) {
        Chunk targetChunk = this.getTargetBlock().getChunk();
        int entityCount = 0;
        int chunkCount = 0;
        try {
            entityCount += this.removeEntities(targetChunk);
            int radius = Math.round(v.getBrushSize() / 16);
            for (int x = targetChunk.getX() - radius; x <= targetChunk.getX() + radius; ++x) {
                for (int z = targetChunk.getZ() - radius; z <= targetChunk.getZ() + radius; ++z) {
                    entityCount += this.removeEntities(this.getWorld().getChunkAt(x, z));
                    ++chunkCount;
                }
            }
        }
        catch (PatternSyntaxException pse) {
            pse.printStackTrace();
            v.sendMessage(ChatColor.RED + "Error in RegEx: " + ChatColor.LIGHT_PURPLE + pse.getPattern());
            v.sendMessage(ChatColor.RED + String.format("%s (Index: %d)", pse.getDescription(), pse.getIndex()));
        }
        v.sendMessage(ChatColor.GREEN + "Removed " + ChatColor.RED + entityCount + ChatColor.GREEN + " entities out of " + ChatColor.BLUE + chunkCount + ChatColor.GREEN + (chunkCount == 1 ? " chunk." : " chunks."));
    }

    private int removeEntities(Chunk chunk) throws PatternSyntaxException {
        int entityCount = 0;
        for (Entity entity : chunk.getEntities()) {
            if (this.isClassInExemptionList(entity.getClass())) continue;
            entity.remove();
            ++entityCount;
        }
        return entityCount;
    }

    private boolean isClassInExemptionList(Class<? extends Entity> entityClass) throws PatternSyntaxException {
        ArrayList<String> entityClassHierarchy = new ArrayList<String>();
        for (Class<? extends Entity> currentClass = entityClass; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
            entityClassHierarchy.add(currentClass.getCanonicalName());
            for (Class<?> intrf : currentClass.getInterfaces()) {
                entityClassHierarchy.add(intrf.getCanonicalName());
            }
        }
        for (String exemptionPattern : this.exemptions) {
            for (String typeName : entityClassHierarchy) {
                if (!typeName.matches(exemptionPattern)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void arrow(SnipeData v) {
        this.radialRemoval(v);
    }

    @Override
    protected void powder(SnipeData v) {
        this.radialRemoval(v);
    }

    @Override
    public void info(Message vm) {
        vm.brushName(this.getName());
        StringBuilder exemptionsList = new StringBuilder(ChatColor.GREEN + "Exemptions: " + ChatColor.LIGHT_PURPLE);
        Iterator<String> it = this.exemptions.iterator();
        while (it.hasNext()) {
            exemptionsList.append((Object)it.next());
            if (!it.hasNext()) continue;
            exemptionsList.append(", ");
        }
        vm.custom(exemptionsList.toString());
        vm.size();
    }

    @Override
    public void parameters(String[] par, SnipeData v) {
        for (String currentParam : par) {
            if (currentParam.startsWith("+") || currentParam.startsWith("-")) {
                String exemptionPattern;
                boolean isAddOperation = currentParam.startsWith("+");
                String string = currentParam.startsWith("+#") || currentParam.startsWith("-#") ? currentParam.substring(2) : (exemptionPattern = currentParam.contains(".") ? currentParam.substring(1) : ".*." + currentParam.substring(1));
                if (isAddOperation) {
                    this.exemptions.add(exemptionPattern);
                    v.sendMessage(String.format("Added %s to entity exemptions list.", exemptionPattern));
                } else {
                    this.exemptions.remove(exemptionPattern);
                    v.sendMessage(String.format("Removed %s from entity exemptions list.", exemptionPattern));
                }
            }
            if (!currentParam.equalsIgnoreCase("list-exemptions") && !currentParam.equalsIgnoreCase("lex")) continue;
            for (String exemption : this.exemptions) {
                v.sendMessage(ChatColor.LIGHT_PURPLE + exemption);
            }
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.entityremoval";
    }
}

