/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.Undo;
import com.thevoxelbox.voxelsniper.brush.Brush;
import org.bukkit.ChatColor;
import org.bukkit.Material;

public class DrainBrush
extends Brush {
    private double trueCircle = 0.0;
    private boolean disc = false;

    public DrainBrush() {
        this.setName("Drain");
    }

    private void drain(SnipeData v) {
        int brushSize = v.getBrushSize();
        double brushSizeSquared = Math.pow((double)brushSize + this.trueCircle, 2.0);
        Undo undo = new Undo();
        if (this.disc) {
            for (int x = brushSize; x >= 0; --x) {
                double xSquared = Math.pow(x, 2.0);
                for (int y = brushSize; y >= 0; --y) {
                    if (!(xSquared + Math.pow(y, 2.0) <= brushSizeSquared)) continue;
                    if (this.getBlockIdAt(this.getTargetBlock().getX() + x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() + y) == Material.WATER.getId() || this.getBlockIdAt(this.getTargetBlock().getX() + x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() + y) == Material.STATIONARY_WATER.getId() || this.getBlockIdAt(this.getTargetBlock().getX() + x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() + y) == Material.LAVA.getId() || this.getBlockIdAt(this.getTargetBlock().getX() + x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() + y) == Material.STATIONARY_LAVA.getId()) {
                        undo.put(this.clampY(this.getTargetBlock().getX() + x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() + y));
                        this.setBlockIdAt(this.getTargetBlock().getZ() + y, this.getTargetBlock().getX() + x, this.getTargetBlock().getY(), Material.AIR.getId());
                    }
                    if (this.getBlockIdAt(this.getTargetBlock().getX() + x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() - y) == Material.WATER.getId() || this.getBlockIdAt(this.getTargetBlock().getX() + x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() - y) == Material.STATIONARY_WATER.getId() || this.getBlockIdAt(this.getTargetBlock().getX() + x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() - y) == Material.LAVA.getId() || this.getBlockIdAt(this.getTargetBlock().getX() + x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() - y) == Material.STATIONARY_LAVA.getId()) {
                        undo.put(this.clampY(this.getTargetBlock().getX() + x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() - y));
                        this.setBlockIdAt(this.getTargetBlock().getZ() - y, this.getTargetBlock().getX() + x, this.getTargetBlock().getY(), Material.AIR.getId());
                    }
                    if (this.getBlockIdAt(this.getTargetBlock().getX() - x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() + y) == Material.WATER.getId() || this.getBlockIdAt(this.getTargetBlock().getX() - x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() + y) == Material.STATIONARY_WATER.getId() || this.getBlockIdAt(this.getTargetBlock().getX() - x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() + y) == Material.LAVA.getId() || this.getBlockIdAt(this.getTargetBlock().getX() - x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() + y) == Material.STATIONARY_LAVA.getId()) {
                        undo.put(this.clampY(this.getTargetBlock().getX() - x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() + y));
                        this.setBlockIdAt(this.getTargetBlock().getZ() + y, this.getTargetBlock().getX() - x, this.getTargetBlock().getY(), Material.AIR.getId());
                    }
                    if (this.getBlockIdAt(this.getTargetBlock().getX() - x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() - y) != Material.WATER.getId() && this.getBlockIdAt(this.getTargetBlock().getX() - x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() - y) != Material.STATIONARY_WATER.getId() && this.getBlockIdAt(this.getTargetBlock().getX() - x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() - y) != Material.LAVA.getId() && this.getBlockIdAt(this.getTargetBlock().getX() - x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() - y) != Material.STATIONARY_LAVA.getId()) continue;
                    undo.put(this.clampY(this.getTargetBlock().getX() - x, this.getTargetBlock().getY(), this.getTargetBlock().getZ() - y));
                    this.setBlockIdAt(this.getTargetBlock().getZ() - y, this.getTargetBlock().getX() - x, this.getTargetBlock().getY(), Material.AIR.getId());
                }
            }
        } else {
            for (int y = (brushSize + 1) * 2; y >= 0; --y) {
                double ySquared = Math.pow(y - brushSize, 2.0);
                for (int x = (brushSize + 1) * 2; x >= 0; --x) {
                    double xSquared = Math.pow(x - brushSize, 2.0);
                    for (int z = (brushSize + 1) * 2; z >= 0; --z) {
                        if (!(xSquared + Math.pow(z - brushSize, 2.0) + ySquared <= brushSizeSquared) || this.getBlockIdAt(this.getTargetBlock().getX() + x - brushSize, this.getTargetBlock().getY() + z - brushSize, this.getTargetBlock().getZ() + y - brushSize) != Material.WATER.getId() && this.getBlockIdAt(this.getTargetBlock().getX() + x - brushSize, this.getTargetBlock().getY() + z - brushSize, this.getTargetBlock().getZ() + y - brushSize) != Material.STATIONARY_WATER.getId() && this.getBlockIdAt(this.getTargetBlock().getX() + x - brushSize, this.getTargetBlock().getY() + z - brushSize, this.getTargetBlock().getZ() + y - brushSize) != Material.LAVA.getId() && this.getBlockIdAt(this.getTargetBlock().getX() + x - brushSize, this.getTargetBlock().getY() + z - brushSize, this.getTargetBlock().getZ() + y - brushSize) != Material.STATIONARY_LAVA.getId()) continue;
                        undo.put(this.clampY(this.getTargetBlock().getX() + x, this.getTargetBlock().getY() + z, this.getTargetBlock().getZ() + y));
                        this.setBlockIdAt(this.getTargetBlock().getZ() + y - brushSize, this.getTargetBlock().getX() + x - brushSize, this.getTargetBlock().getY() + z - brushSize, Material.AIR.getId());
                    }
                }
            }
        }
        v.owner().storeUndo(undo);
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.drain(v);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.drain(v);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.custom(ChatColor.AQUA + (this.trueCircle == 0.5 ? "True circle mode ON" : "True circle mode OFF"));
        vm.custom(ChatColor.AQUA + (this.disc ? "Disc drain mode ON" : "Disc drain mode OFF"));
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 1; i < par.length; ++i) {
            String parameter = par[i];
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(ChatColor.GOLD + "Drain Brush Parameters:");
                v.sendMessage(ChatColor.AQUA + "/b drain true -- will use a true sphere algorithm instead of the skinnier version with classic sniper nubs. /b drain false will switch back. (false is default)");
                v.sendMessage(ChatColor.AQUA + "/b drain d -- toggles disc drain mode, as opposed to a ball drain mode");
                return;
            }
            if (parameter.startsWith("true")) {
                this.trueCircle = 0.5;
                v.sendMessage(ChatColor.AQUA + "True circle mode ON.");
                continue;
            }
            if (parameter.startsWith("false")) {
                this.trueCircle = 0.0;
                v.sendMessage(ChatColor.AQUA + "True circle mode OFF.");
                continue;
            }
            if (parameter.equalsIgnoreCase("d")) {
                if (this.disc) {
                    this.disc = false;
                    v.sendMessage(ChatColor.AQUA + "Disc drain mode OFF");
                    continue;
                }
                this.disc = true;
                v.sendMessage(ChatColor.AQUA + "Disc drain mode ON");
                continue;
            }
            v.sendMessage(ChatColor.RED + "Invalid brush parameters! use the info parameter to display parameter info.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.drain";
    }
}

