/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.perform.PerformBrush;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class DiscBrush
extends PerformBrush {
    private double trueCircle = 0.0;

    public DiscBrush() {
        this.setName("Disc");
    }

    private void disc(SnipeData v, Block targetBlock) {
        double radiusSquared = ((double)v.getBrushSize() + this.trueCircle) * ((double)v.getBrushSize() + this.trueCircle);
        Vector centerPoint = targetBlock.getLocation().toVector();
        Vector currentPoint = centerPoint.clone();
        for (int x = -v.getBrushSize(); x <= v.getBrushSize(); ++x) {
            currentPoint.setX(centerPoint.getX() + (double)x);
            for (int z = -v.getBrushSize(); z <= v.getBrushSize(); ++z) {
                currentPoint.setZ(centerPoint.getZ() + (double)z);
                if (!(centerPoint.distanceSquared(currentPoint) <= radiusSquared)) continue;
                this.current.perform(this.clampY(currentPoint.getBlockX(), currentPoint.getBlockY(), currentPoint.getBlockZ()));
            }
        }
        v.owner().storeUndo(this.current.getUndo());
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.disc(v, this.getTargetBlock());
    }

    @Override
    protected final void powder(SnipeData v) {
        this.disc(v, this.getLastBlock());
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 1; i < par.length; ++i) {
            String parameter = par[i].toLowerCase();
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(ChatColor.GOLD + "Disc Brush Parameters:");
                v.sendMessage(ChatColor.AQUA + "/b d true|false -- toggles useing the true circle algorithm instead of the skinnier version with classic sniper nubs. (false is default)");
                return;
            }
            if (parameter.startsWith("true")) {
                this.trueCircle = 0.5;
                v.sendMessage(ChatColor.AQUA + "True circle mode ON.");
                continue;
            }
            if (parameter.startsWith("false")) {
                this.trueCircle = 0.0;
                v.sendMessage(ChatColor.AQUA + "True circle mode OFF.");
                continue;
            }
            v.sendMessage(ChatColor.RED + "Invalid brush parameters! use the info parameter to display parameter info.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.disc";
    }
}

