/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.Brush;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.SmallFireball;
import org.bukkit.util.Vector;

public class CometBrush
extends Brush {
    private boolean useBigBalls = false;

    public CometBrush() {
        this.setName("Comet");
    }

    private void doFireball(SnipeData v) {
        Vector targetCoords = new Vector((double)this.getTargetBlock().getX() + 0.5 * (double)this.getTargetBlock().getX() / (double)Math.abs(this.getTargetBlock().getX()), (double)this.getTargetBlock().getY() + 0.5, (double)this.getTargetBlock().getZ() + 0.5 * (double)this.getTargetBlock().getZ() / (double)Math.abs(this.getTargetBlock().getZ()));
        Location playerLocation = v.owner().getPlayer().getEyeLocation();
        Vector slope = targetCoords.subtract(playerLocation.toVector());
        if (this.useBigBalls) {
            ((LargeFireball)v.owner().getPlayer().launchProjectile(LargeFireball.class)).setVelocity(slope.normalize());
        } else {
            ((SmallFireball)v.owner().getPlayer().launchProjectile(SmallFireball.class)).setVelocity(slope.normalize());
        }
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 0; i < par.length; ++i) {
            String newBallSize;
            String parameter = par[i];
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage("Parameters:");
                v.sendMessage("balls [big|small]  -- Sets your ball size.");
            }
            if (!parameter.equalsIgnoreCase("balls")) continue;
            if (i + 1 >= par.length) {
                v.sendMessage("The balls parameter expects a ball size after it.");
            }
            if ((newBallSize = par[++i]).equalsIgnoreCase("big")) {
                this.useBigBalls = true;
                v.sendMessage("Your balls are " + ChatColor.DARK_RED + "BIG");
                continue;
            }
            if (newBallSize.equalsIgnoreCase("small")) {
                this.useBigBalls = false;
                v.sendMessage("Your balls are " + ChatColor.DARK_RED + "small");
                continue;
            }
            v.sendMessage("Unknown ball size.");
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.doFireball(v);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.doFireball(v);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.voxel();
        vm.custom("Your balls are " + ChatColor.DARK_RED + (this.useBigBalls ? "BIG" : "small"));
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.comet";
    }
}

