/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.perform.PerformBrush;
import java.util.Random;
import org.bukkit.ChatColor;

public class BlobBrush
extends PerformBrush {
    private static final int GROW_PERCENT_DEFAULT = 1000;
    private static final int GROW_PERCENT_MIN = 1;
    private static final int GROW_PERCENT_MAX = 9999;
    private Random randomGenerator = new Random();
    private int growPercent = 1000;

    public BlobBrush() {
        this.setName("Blob");
    }

    private void checkValidGrowPercent(SnipeData v) {
        if (this.growPercent < 1 || this.growPercent > 9999) {
            this.growPercent = 1000;
            v.sendMessage(ChatColor.BLUE + "Growth percent set to: 10%");
        }
    }

    private void digBlob(SnipeData v) {
        int brushSize = v.getBrushSize();
        int brushSizeDoubled = 2 * brushSize;
        int[][][] splat = new int[brushSizeDoubled + 1][brushSizeDoubled + 1][brushSizeDoubled + 1];
        int[][][] tempSplat = new int[brushSizeDoubled + 1][brushSizeDoubled + 1][brushSizeDoubled + 1];
        this.checkValidGrowPercent(v);
        for (int x = brushSizeDoubled; x >= 0; --x) {
            for (int y = brushSizeDoubled; y >= 0; --y) {
                for (int z = brushSizeDoubled; z >= 0; --z) {
                    splat[x][y][z] = (x == 0 || y == 0 | z == 0 || x == brushSizeDoubled || y == brushSizeDoubled || z == brushSizeDoubled) && this.randomGenerator.nextInt(10000) <= this.growPercent ? 0 : 1;
                }
            }
        }
        for (int r = 0; r < brushSize; ++r) {
            int z;
            int y;
            int x;
            for (x = brushSizeDoubled; x >= 0; --x) {
                for (y = brushSizeDoubled; y >= 0; --y) {
                    for (z = brushSizeDoubled; z >= 0; --z) {
                        tempSplat[x][y][z] = splat[x][y][z];
                        double growCheck = 0.0;
                        if (splat[x][y][z] == 1) {
                            if (x != 0 && splat[x - 1][y][z] == 0) {
                                growCheck += 1.0;
                            }
                            if (y != 0 && splat[x][y - 1][z] == 0) {
                                growCheck += 1.0;
                            }
                            if (z != 0 && splat[x][y][z - 1] == 0) {
                                growCheck += 1.0;
                            }
                            if (x != 2 * brushSize && splat[x + 1][y][z] == 0) {
                                growCheck += 1.0;
                            }
                            if (y != 2 * brushSize && splat[x][y + 1][z] == 0) {
                                growCheck += 1.0;
                            }
                            if (z != 2 * brushSize && splat[x][y][z + 1] == 0) {
                                growCheck += 1.0;
                            }
                        }
                        if (!(growCheck >= 1.0) || this.randomGenerator.nextInt(10000) > this.growPercent) continue;
                        tempSplat[x][y][z] = 0;
                    }
                }
            }
            for (x = brushSizeDoubled; x >= 0; --x) {
                for (y = brushSizeDoubled; y >= 0; --y) {
                    for (z = brushSizeDoubled; z >= 0; --z) {
                        splat[x][y][z] = tempSplat[x][y][z];
                    }
                }
            }
        }
        double rSquared = Math.pow(brushSize + 1, 2.0);
        for (int x = brushSizeDoubled; x >= 0; --x) {
            double xSquared = Math.pow(x - brushSize - 1, 2.0);
            for (int y = brushSizeDoubled; y >= 0; --y) {
                double ySquared = Math.pow(y - brushSize - 1, 2.0);
                for (int z = brushSizeDoubled; z >= 0; --z) {
                    if (splat[x][y][z] != 1 || !(xSquared + ySquared + Math.pow(z - brushSize - 1, 2.0) <= rSquared)) continue;
                    this.current.perform(this.clampY(this.getTargetBlock().getX() - brushSize + x, this.getTargetBlock().getY() - brushSize + z, this.getTargetBlock().getZ() - brushSize + y));
                }
            }
        }
        v.owner().storeUndo(this.current.getUndo());
    }

    private void growBlob(SnipeData v) {
        int brushSize = v.getBrushSize();
        int brushSizeDoubled = 2 * brushSize;
        int[][][] splat = new int[brushSizeDoubled + 1][brushSizeDoubled + 1][brushSizeDoubled + 1];
        int[][][] tempSplat = new int[brushSizeDoubled + 1][brushSizeDoubled + 1][brushSizeDoubled + 1];
        this.checkValidGrowPercent(v);
        splat[brushSize][brushSize][brushSize] = 1;
        for (int r = 0; r < brushSize; ++r) {
            int z;
            int y;
            int x;
            for (x = brushSizeDoubled; x >= 0; --x) {
                for (y = brushSizeDoubled; y >= 0; --y) {
                    for (z = brushSizeDoubled; z >= 0; --z) {
                        tempSplat[x][y][z] = splat[x][y][z];
                        int growCheck = 0;
                        if (splat[x][y][z] == 0) {
                            if (x != 0 && splat[x - 1][y][z] == 1) {
                                ++growCheck;
                            }
                            if (y != 0 && splat[x][y - 1][z] == 1) {
                                ++growCheck;
                            }
                            if (z != 0 && splat[x][y][z - 1] == 1) {
                                ++growCheck;
                            }
                            if (x != 2 * brushSize && splat[x + 1][y][z] == 1) {
                                ++growCheck;
                            }
                            if (y != 2 * brushSize && splat[x][y + 1][z] == 1) {
                                ++growCheck;
                            }
                            if (z != 2 * brushSize && splat[x][y][z + 1] == 1) {
                                ++growCheck;
                            }
                        }
                        if (growCheck < true || this.randomGenerator.nextInt(10000) > this.growPercent) continue;
                        tempSplat[x][y][z] = 1;
                    }
                }
            }
            for (x = brushSizeDoubled; x >= 0; --x) {
                for (y = brushSizeDoubled; y >= 0; --y) {
                    for (z = brushSizeDoubled; z >= 0; --z) {
                        splat[x][y][z] = tempSplat[x][y][z];
                    }
                }
            }
        }
        double rSquared = Math.pow(brushSize + 1, 2.0);
        for (int x = brushSizeDoubled; x >= 0; --x) {
            double xSquared = Math.pow(x - brushSize - 1, 2.0);
            for (int y = brushSizeDoubled; y >= 0; --y) {
                double ySquared = Math.pow(y - brushSize - 1, 2.0);
                for (int z = brushSizeDoubled; z >= 0; --z) {
                    if (splat[x][y][z] != 1 || !(xSquared + ySquared + Math.pow(z - brushSize - 1, 2.0) <= rSquared)) continue;
                    this.current.perform(this.clampY(this.getTargetBlock().getX() - brushSize + x, this.getTargetBlock().getY() - brushSize + z, this.getTargetBlock().getZ() - brushSize + y));
                }
            }
        }
        v.owner().storeUndo(this.current.getUndo());
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.growBlob(v);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.digBlob(v);
    }

    @Override
    public final void info(Message vm) {
        this.checkValidGrowPercent(null);
        vm.brushName(this.getName());
        vm.size();
        vm.custom(ChatColor.BLUE + "Growth percent set to: " + this.growPercent / 100 + "%");
    }

    @Override
    public final void parameters(String[] par, SnipeData v) {
        for (int i = 1; i < par.length; ++i) {
            String parameter = par[i];
            if (parameter.equalsIgnoreCase("info")) {
                v.sendMessage(ChatColor.GOLD + "Blob brush Parameters:");
                v.sendMessage(ChatColor.AQUA + "/b blob g[int] -- set a growth percentage (" + 1 + "-" + 9999 + ").  Default is " + 1000);
                return;
            }
            if (parameter.startsWith("g")) {
                int temp = Integer.parseInt(parameter.replace("g", ""));
                if (temp >= 1 && temp <= 9999) {
                    v.sendMessage(ChatColor.AQUA + "Growth percent set to: " + (float)temp / 100.0f + "%");
                    this.growPercent = temp;
                    continue;
                }
                v.sendMessage(ChatColor.RED + "Growth percent must be an integer " + 1 + "-" + 9999 + "!");
                continue;
            }
            v.sendMessage(ChatColor.RED + "Invalid brush parameters! use the info parameter to display parameter info.");
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.blob";
    }
}

