/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper.brush;

import com.thevoxelbox.voxelsniper.Message;
import com.thevoxelbox.voxelsniper.SnipeData;
import com.thevoxelbox.voxelsniper.brush.Brush;
import org.bukkit.ChatColor;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;

public class BiomeBrush
extends Brush {
    private Biome selectedBiome = Biome.PLAINS;

    public BiomeBrush() {
        this.setName("Biome (/b biome [Biome Name])");
    }

    private void biome(SnipeData v) {
        int brushSize = v.getBrushSize();
        double brushSizeSquared = Math.pow(brushSize, 2.0);
        for (int x = -brushSize; x <= brushSize; ++x) {
            double xSquared = Math.pow(x, 2.0);
            for (int z = -brushSize; z <= brushSize; ++z) {
                if (!(xSquared + Math.pow(z, 2.0) <= brushSizeSquared)) continue;
                this.getWorld().setBiome(this.getTargetBlock().getX() + x, this.getTargetBlock().getZ() + z, this.selectedBiome);
            }
        }
        Block block1 = this.getWorld().getBlockAt(this.getTargetBlock().getX() - brushSize, 0, this.getTargetBlock().getZ() - brushSize);
        Block block2 = this.getWorld().getBlockAt(this.getTargetBlock().getX() + brushSize, 0, this.getTargetBlock().getZ() + brushSize);
        int lowChunkX = block1.getX() <= block2.getX() ? block1.getChunk().getX() : block2.getChunk().getX();
        int lowChunkZ = block1.getZ() <= block2.getZ() ? block1.getChunk().getZ() : block2.getChunk().getZ();
        int highChunkX = block1.getX() >= block2.getX() ? block1.getChunk().getX() : block2.getChunk().getX();
        int highChunkZ = block1.getZ() >= block2.getZ() ? block1.getChunk().getZ() : block2.getChunk().getZ();
        for (int x = lowChunkX; x <= highChunkX; ++x) {
            for (int z = lowChunkZ; z <= highChunkZ; ++z) {
                this.getWorld().refreshChunk(x, z);
            }
        }
    }

    @Override
    protected final void arrow(SnipeData v) {
        this.biome(v);
    }

    @Override
    protected final void powder(SnipeData v) {
        this.biome(v);
    }

    @Override
    public final void info(Message vm) {
        vm.brushName(this.getName());
        vm.size();
        vm.custom(ChatColor.GOLD + "Currently selected biome type: " + ChatColor.DARK_GREEN + this.selectedBiome.name());
    }

    @Override
    public final void parameters(String[] args, SnipeData v) {
        if (args[1].equalsIgnoreCase("info")) {
            v.sendMessage(ChatColor.GOLD + "Biome Brush Parameters:");
            String availableBiomes = "";
            for (Biome biome : Biome.values()) {
                availableBiomes = availableBiomes.isEmpty() ? ChatColor.DARK_GREEN + biome.name() : availableBiomes + ChatColor.RED + ", " + ChatColor.DARK_GREEN + biome.name();
            }
            v.sendMessage(ChatColor.DARK_BLUE + "Available biomes: " + availableBiomes);
        } else {
            String biomeName = args[1];
            for (int i = 2; i < args.length; ++i) {
                biomeName = biomeName + " " + args[i];
            }
            for (Biome biome : Biome.values()) {
                if (!biome.name().equalsIgnoreCase(biomeName)) continue;
                this.selectedBiome = biome;
                break;
            }
            v.sendMessage(ChatColor.GOLD + "Currently selected biome type: " + ChatColor.DARK_GREEN + this.selectedBiome.name());
        }
    }

    @Override
    public String getPermissionNode() {
        return "voxelsniper.brush.biome";
    }
}

