/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper;

import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class RangeBlockHelper {
    private static final int MAXIMUM_WORLD_HEIGHT = 255;
    private static final double DEFAULT_PLAYER_VIEW_HEIGHT = 1.65;
    private static final double DEFAULT_LOCATION_VIEW_HEIGHT = 0.0;
    private static final double DEFAULT_STEP = 0.2;
    private static final int DEFAULT_RANGE = 250;
    private Location playerLoc;
    private double rotX;
    private double rotY;
    private double viewHeight;
    private double rotXSin;
    private double rotXCos;
    private double rotYSin;
    private double rotYCos;
    private double length;
    private double hLength;
    private double step;
    private double range;
    private double playerX;
    private double playerY;
    private double playerZ;
    private double xOffset;
    private double yOffset;
    private double zOffset;
    private int lastX;
    private int lastY;
    private int lastZ;
    private int targetX;
    private int targetY;
    private int targetZ;
    private World world;

    public RangeBlockHelper(Location location) {
        this.init(location, 250.0, 0.2, 0.0);
    }

    public RangeBlockHelper(Location location, int range, double step) {
        this.world = location.getWorld();
        this.init(location, range, step, 0.0);
    }

    public RangeBlockHelper(Player player, int range, double step) {
        this.init(player.getLocation(), range, step, 1.65);
    }

    public RangeBlockHelper(Player player, World world) {
        this.world = world;
        this.init(player.getLocation(), 250.0, 0.2, 1.65);
    }

    public RangeBlockHelper(Player player, World world, double range) {
        this.world = world;
        this.init(player.getLocation(), range, 0.2, 1.65);
        this.fromOffworld();
    }

    public final void fromOffworld() {
        block5: {
            block4: {
                if (this.targetY <= 255) break block4;
                while (this.targetY > 255 && this.length <= this.range) {
                    this.lastX = this.targetX;
                    this.lastY = this.targetY;
                    this.lastZ = this.targetZ;
                    do {
                        this.length += this.step;
                        this.hLength = this.length * this.rotYCos;
                        this.yOffset = this.length * this.rotYSin;
                        this.xOffset = this.hLength * this.rotXCos;
                        this.zOffset = this.hLength * this.rotXSin;
                        this.targetX = (int)Math.floor(this.xOffset + this.playerX);
                        this.targetY = (int)Math.floor(this.yOffset + this.playerY);
                        this.targetZ = (int)Math.floor(this.zOffset + this.playerZ);
                    } while (this.length <= this.range && this.targetX == this.lastX && this.targetY == this.lastY && this.targetZ == this.lastZ);
                }
                break block5;
            }
            if (this.targetY >= 0) break block5;
            while (this.targetY < 0 && this.length <= this.range) {
                this.lastX = this.targetX;
                this.lastY = this.targetY;
                this.lastZ = this.targetZ;
                do {
                    this.length += this.step;
                    this.hLength = this.length * this.rotYCos;
                    this.yOffset = this.length * this.rotYSin;
                    this.xOffset = this.hLength * this.rotXCos;
                    this.zOffset = this.hLength * this.rotXSin;
                    this.targetX = (int)Math.floor(this.xOffset + this.playerX);
                    this.targetY = (int)Math.floor(this.yOffset + this.playerY);
                    this.targetZ = (int)Math.floor(this.zOffset + this.playerZ);
                } while (this.length <= this.range && this.targetX == this.lastX && this.targetY == this.lastY && this.targetZ == this.lastZ);
            }
        }
    }

    public final Block getCurBlock() {
        if (this.length > this.range || this.targetY > 255 || this.targetY < 0) {
            return null;
        }
        return this.world.getBlockAt(this.targetX, this.targetY, this.targetZ);
    }

    public final Block getFaceBlock() {
        while (this.getNextBlock() != null && this.getCurBlock().getTypeId() == 0) {
        }
        if (this.getCurBlock() != null) {
            return this.getLastBlock();
        }
        return null;
    }

    public final Block getLastBlock() {
        if (this.lastY > 255 || this.lastY < 0) {
            return null;
        }
        return this.world.getBlockAt(this.lastX, this.lastY, this.lastZ);
    }

    public final Block getNextBlock() {
        this.lastX = this.targetX;
        this.lastY = this.targetY;
        this.lastZ = this.targetZ;
        do {
            this.length += this.step;
            this.hLength = this.length * this.rotYCos;
            this.yOffset = this.length * this.rotYSin;
            this.xOffset = this.hLength * this.rotXCos;
            this.zOffset = this.hLength * this.rotXSin;
            this.targetX = (int)Math.floor(this.xOffset + this.playerX);
            this.targetY = (int)Math.floor(this.yOffset + this.playerY);
            this.targetZ = (int)Math.floor(this.zOffset + this.playerZ);
        } while (this.length <= this.range && this.targetX == this.lastX && this.targetY == this.lastY && this.targetZ == this.lastZ);
        if (this.length > this.range || this.targetY > 255 || this.targetY < 0) {
            return null;
        }
        return this.world.getBlockAt(this.targetX, this.targetY, this.targetZ);
    }

    public final Block getRangeBlock() {
        this.fromOffworld();
        if (this.length > this.range) {
            return null;
        }
        return this.getRange();
    }

    public final Block getTargetBlock() {
        this.fromOffworld();
        while (this.getNextBlock() != null && this.getCurBlock().getTypeId() == 0) {
        }
        return this.getCurBlock();
    }

    public final void setCurBlock(int type) {
        if (this.getCurBlock() != null) {
            this.world.getBlockAt(this.targetX, this.targetY, this.targetZ).setTypeId(type);
        }
    }

    public final void setFaceBlock(int type) {
        while (this.getNextBlock() != null && this.getCurBlock().getTypeId() == 0) {
        }
        if (this.getCurBlock() != null) {
            this.world.getBlockAt(this.targetX, this.targetY, this.targetZ).setTypeId(type);
        }
    }

    public final void setLastBlock(int type) {
        if (this.getLastBlock() != null) {
            this.world.getBlockAt(this.lastX, this.lastY, this.lastZ).setTypeId(type);
        }
    }

    public final void setTargetBlock(int type) {
        while (this.getNextBlock() != null && this.getCurBlock().getTypeId() == 0) {
        }
        if (this.getCurBlock() != null) {
            this.world.getBlockAt(this.targetX, this.targetY, this.targetZ).setTypeId(type);
        }
    }

    private Block getRange() {
        this.lastX = this.targetX;
        this.lastY = this.targetY;
        this.lastZ = this.targetZ;
        do {
            this.length += this.step;
            this.hLength = this.length * this.rotYCos;
            this.yOffset = this.length * this.rotYSin;
            this.xOffset = this.hLength * this.rotXCos;
            this.zOffset = this.hLength * this.rotXSin;
            this.targetX = (int)Math.floor(this.xOffset + this.playerX);
            this.targetY = (int)Math.floor(this.yOffset + this.playerY);
            this.targetZ = (int)Math.floor(this.zOffset + this.playerZ);
        } while (this.length <= this.range && this.targetX == this.lastX && this.targetY == this.lastY && this.targetZ == this.lastZ);
        if (this.world.getBlockTypeIdAt(this.targetX, this.targetY, this.targetZ) != 0) {
            return this.world.getBlockAt(this.targetX, this.targetY, this.targetZ);
        }
        if (this.length > this.range || this.targetY > 255 || this.targetY < 0) {
            return this.world.getBlockAt(this.lastX, this.lastY, this.lastZ);
        }
        return this.getRange();
    }

    private void init(Location location, double range, double step, double viewHeight) {
        this.playerLoc = location;
        this.viewHeight = viewHeight;
        this.playerX = this.playerLoc.getX();
        this.playerY = this.playerLoc.getY() + this.viewHeight;
        this.playerZ = this.playerLoc.getZ();
        this.range = range;
        this.step = step;
        this.length = 0.0;
        this.rotX = (this.playerLoc.getYaw() + 90.0f) % 360.0f;
        this.rotY = this.playerLoc.getPitch() * -1.0f;
        this.rotYCos = Math.cos(Math.toRadians(this.rotY));
        this.rotYSin = Math.sin(Math.toRadians(this.rotY));
        this.rotXCos = Math.cos(Math.toRadians(this.rotX));
        this.rotXSin = Math.sin(Math.toRadians(this.rotX));
        this.targetX = (int)Math.floor(this.playerLoc.getX());
        this.targetY = (int)Math.floor(this.playerLoc.getY() + this.viewHeight);
        this.targetZ = (int)Math.floor(this.playerLoc.getZ());
        this.lastX = this.targetX;
        this.lastY = this.targetY;
        this.lastZ = this.targetZ;
    }
}

