/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelsniper;

import com.thevoxelbox.voxelsniper.brush.IBrush;
import com.thevoxelbox.voxelsniper.libs.com.google.common.base.Preconditions;
import com.thevoxelbox.voxelsniper.libs.com.google.common.collect.HashMultimap;
import com.thevoxelbox.voxelsniper.libs.com.google.common.collect.ImmutableMultimap;
import com.thevoxelbox.voxelsniper.libs.com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Brushes {
    private Multimap<Class<? extends IBrush>, String> brushes = HashMultimap.create();

    public void registerSniperBrush(Class<? extends IBrush> clazz, String ... handles) {
        Preconditions.checkNotNull(clazz, "Cannot register null as a class.");
        for (String handle : handles) {
            this.brushes.put(clazz, handle.toLowerCase());
        }
    }

    public Class<? extends IBrush> getBrushForHandle(String handle) {
        Preconditions.checkNotNull(handle, "Brushhandle can not be null.");
        if (!this.brushes.containsValue(handle.toLowerCase())) {
            return null;
        }
        for (Map.Entry<Class<? extends IBrush>, String> entry : this.brushes.entries()) {
            if (!entry.getValue().equalsIgnoreCase(handle)) continue;
            return entry.getKey();
        }
        return null;
    }

    public int registeredSniperBrushes() {
        return this.brushes.keySet().size();
    }

    public int registeredSniperBrushHandles() {
        return this.brushes.size();
    }

    public Set<String> getSniperBrushHandles(Class<? extends IBrush> clazz) {
        return new HashSet<String>(this.brushes.get(clazz));
    }

    public Multimap<Class<? extends IBrush>, String> getRegisteredBrushesMultimap() {
        return ImmutableMultimap.copyOf(this.brushes);
    }
}

