/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.mixinbooter.mixin;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.crash.CrashReport;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import zone.rong.mixinbooter.ConfigDecorators;
import zone.rong.mixinbooter.MixinBooterPlugin;

@Mixin(value={CrashReport.class})
public class CrashReportMixin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getCauseStackTraceOrString"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void afterStackTracePopulation(CallbackInfoReturnable<String> cir, StringWriter stringwriter, PrintWriter printwriter, Throwable throwable) {
        StackTraceElement[] stacktrace;
        boolean hasErrored = false;
        StringBuilder mixinMetadataBuilder = null;
        while (throwable != null && (stacktrace = throwable.getStackTrace()).length > 0) {
            try {
                HashSet<String> classes = new HashSet<String>();
                for (StackTraceElement stackTraceElement : stacktrace) {
                    classes.add(stackTraceElement.getClassName().replace('.', '/'));
                }
                try {
                    Field classInfo$mixins = ClassInfo.class.getDeclaredField("mixins");
                    classInfo$mixins.setAccessible(true);
                    block9: for (String className : classes) {
                        for (ClassInfo classInfo = ClassInfo.fromCache(className); classInfo != null; classInfo = classInfo.getSuperClass()) {
                            mixinMetadataBuilder = this.findAndAddMixinMetadata(classInfo$mixins, mixinMetadataBuilder, className, classInfo);
                            className = classInfo.getSuperName();
                            if (className == null || className.isEmpty() || "java/lang/Object".equals(className)) continue block9;
                        }
                    }
                }
                catch (ReflectiveOperationException e) {
                    MixinBooterPlugin.LOGGER.warn("Not able to reflect ClassInfo#getMixins", (Throwable)e);
                    throw e;
                }
            }
            catch (Throwable t) {
                cir.setReturnValue(cir.getReturnValue() + "\nFailed to find Mixin Metadata in Stacktrace:\n" + t);
                hasErrored = true;
            }
            finally {
                throwable = throwable.getCause();
            }
        }
        if (!hasErrored) {
            if (mixinMetadataBuilder == null) {
                cir.setReturnValue(cir.getReturnValue() + "\nNo Mixin Metadata is found in the Stacktrace.\n");
            } else {
                cir.setReturnValue(cir.getReturnValue() + mixinMetadataBuilder);
            }
        }
    }

    private StringBuilder findAndAddMixinMetadata(Field classInfo$mixins, StringBuilder mixinMetadataBuilder, String className, ClassInfo classInfo) throws IllegalAccessException {
        Set mixinInfos = (Set)classInfo$mixins.get(classInfo);
        if (!mixinInfos.isEmpty()) {
            if (mixinMetadataBuilder == null) {
                mixinMetadataBuilder = new StringBuilder("\n(MixinBooter) Mixins in Stacktrace:");
            }
            mixinMetadataBuilder.append("\n\t");
            mixinMetadataBuilder.append(className);
            mixinMetadataBuilder.append(':');
            for (IMixinInfo mixinInfo : mixinInfos) {
                mixinMetadataBuilder.append("\n\t\t");
                mixinMetadataBuilder.append(mixinInfo.getClassName());
                mixinMetadataBuilder.append(" (");
                mixinMetadataBuilder.append(mixinInfo.getConfig());
                mixinMetadataBuilder.append(") [");
                mixinMetadataBuilder.append(ConfigDecorators.getDecoratedMixinLocation(mixinInfo));
                mixinMetadataBuilder.append("]");
            }
        }
        return mixinMetadataBuilder;
    }
}

