/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.commands;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.commands.MultiverseCommand;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;

public class GameruleCommand
extends MultiverseCommand {
    public GameruleCommand(MultiverseCore plugin) {
        super(plugin);
        this.setName("Set a Minecraft Game Rule for a World.");
        this.setCommandUsage("/mv gamerule " + ChatColor.GREEN + "{RULE} {VALUE}" + ChatColor.GOLD + " [WORLD]");
        this.setArgRange(2, 3);
        this.addKey("mv gamerule");
        this.addKey("mv rule");
        this.addKey("mvgamerule");
        this.addKey("mvrule");
        this.addCommandExample("/mv gamerule " + ChatColor.GREEN + "doMobLoot false");
        this.addCommandExample("/mvrule " + ChatColor.GREEN + "keepInventory true " + ChatColor.RED + "world_nether");
        this.setPermission("multiverse.core.gamerule.set", "Allows a player to set a gamerule.", PermissionDefault.OP);
    }

    @Override
    public void runCommand(CommandSender sender, List<String> args) {
        Player p = sender instanceof Player ? (Player)sender : null;
        if (args.size() == 2 && p == null) {
            sender.sendMessage("From the command line, WORLD is required.");
            sender.sendMessage(this.getCommandDesc());
            sender.sendMessage(this.getCommandUsage());
            sender.sendMessage("Nothing changed.");
            return;
        }
        String gameRule = args.get(0);
        String value = args.get(1);
        World world = args.size() == 2 ? p.getWorld() : Bukkit.getWorld((String)args.get(2));
        if (world.setGameRuleValue(gameRule, value)) {
            sender.sendMessage(ChatColor.GREEN + "Success!" + ChatColor.WHITE + " Gamerule " + ChatColor.AQUA + gameRule + ChatColor.WHITE + " was set to " + ChatColor.GREEN + value);
        } else {
            sender.sendMessage(ChatColor.RED + "Failure!" + ChatColor.WHITE + " Gamerule " + ChatColor.AQUA + gameRule + ChatColor.WHITE + " cannot be set to " + ChatColor.RED + value);
        }
    }
}

