/*
 * Decompiled with CFR 0.152.
 */
package net.ess3.api;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.plugin.Plugin;

public final class PluginKey {
    private final Plugin plugin;
    private final String key;

    private PluginKey(Plugin plugin, String key) {
        this.plugin = plugin;
        this.key = key;
    }

    public static PluginKey random(Plugin plugin) {
        return new PluginKey(plugin, UUID.randomUUID().toString());
    }

    public static PluginKey fromKey(Plugin plugin, String key) {
        return new PluginKey(plugin, key);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        return Objects.hash(this.plugin, this.key);
    }

    public String toString() {
        return this.plugin.getName().toLowerCase() + ":" + this.key;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PluginKey) && !o.getClass().getName().equals("org.bukkit.NamespacedKey")) {
            return false;
        }
        return this == o || this.toString().equals(o.toString());
    }
}

