/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.utils.NumberUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.ess3.api.IUser;
import net.essentialsx.api.v2.events.HomeModifyEvent;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.event.Event;

public class Commandrenamehome
extends EssentialsCommand {
    public Commandrenamehome() {
        super("renamehome");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        String oldName;
        String newName;
        User usersHome = user;
        if (args.length == 2) {
            String[] nameParts = args[0].split(":", 2);
            newName = args[1].toLowerCase(Locale.ENGLISH);
            if (nameParts.length == 2) {
                oldName = nameParts[1].toLowerCase(Locale.ENGLISH);
                if (user.isAuthorized("essentials.renamehome.others") && (usersHome = this.getPlayer(server, nameParts[0], true, true)) == null) {
                    throw new PlayerNotFoundException();
                }
            } else {
                oldName = args[0].toLowerCase(Locale.ENGLISH);
            }
        } else if (args.length == 3) {
            if (!user.isAuthorized("essentials.renamehome.others")) {
                throw new NotEnoughArgumentsException();
            }
            usersHome = this.getPlayer(server, args[0], true, true);
            if (usersHome == null) {
                throw new PlayerNotFoundException();
            }
            oldName = args[1].toLowerCase(Locale.ENGLISH);
            newName = args[2].toLowerCase(Locale.ENGLISH);
        } else {
            throw new NotEnoughArgumentsException();
        }
        if ("bed".equals(newName) || NumberUtil.isInt(newName) || "bed".equals(oldName) || NumberUtil.isInt(oldName)) {
            throw new NoSuchFieldException(I18n.tl("invalidHomeName", new Object[0]));
        }
        HomeModifyEvent event = new HomeModifyEvent((IUser)user, (IUser)usersHome, oldName, newName, usersHome.getHome(oldName));
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().info("HomeModifyEvent canceled for /renamehome execution by " + user.getDisplayName());
            }
            return;
        }
        usersHome.renameHome(oldName, newName);
        user.sendMessage(I18n.tl("homeRenamed", oldName, newName));
        usersHome.setLastHomeConfirmation(null);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        IUser user = sender.getUser(this.ess);
        if (args.length != 1) {
            return Collections.emptyList();
        }
        ArrayList<String> homes = user == null ? new ArrayList() : user.getHomes();
        boolean canRenameOthers = sender.isAuthorized("essentials.renamehome.others", this.ess);
        if (canRenameOthers) {
            int sepIndex = args[0].indexOf(58);
            if (sepIndex < 0) {
                this.getPlayers(server, sender).forEach(player -> homes.add(player + ":"));
            } else {
                User otherUser;
                String namePart = args[0].substring(0, sepIndex);
                try {
                    otherUser = this.getPlayer(server, new String[]{namePart}, 0, true, true);
                }
                catch (Exception ex) {
                    return homes;
                }
                otherUser.getHomes().forEach(home -> homes.add(namePart + ":" + home));
            }
        }
        return homes;
    }
}

