/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.Locale;
import org.bukkit.Server;

public class Commandrealname
extends EssentialsCommand {
    public Commandrealname() {
        super("realname");
    }

    @Override
    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length == 0) {
            throw new NotEnoughArgumentsException();
        }
        String lookup = args[0].toLowerCase(Locale.ENGLISH);
        boolean skipHidden = sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).canInteractVanished();
        boolean foundUser = false;
        for (User u : this.ess.getOnlineUsers()) {
            if (skipHidden && u.isHidden(sender.getPlayer()) && u.isHiddenFrom(sender.getPlayer())) continue;
            u.setDisplayNick();
            if (!FormatUtil.stripFormat(u.getDisplayName()).toLowerCase(Locale.ENGLISH).contains(lookup)) continue;
            foundUser = true;
            sender.sendMessage(I18n.tl("realName", u.getDisplayName(), u.getName()));
        }
        if (!foundUser) {
            throw new PlayerNotFoundException();
        }
    }
}

