/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.craftbukkit.Inventories;
import com.earth2me.essentials.libs.configurate.ConfigurationNode;
import com.earth2me.essentials.libs.configurate.yaml.NodeStyle;
import com.earth2me.essentials.libs.configurate.yaml.YamlConfigurationLoader;
import com.earth2me.essentials.libs.snakeyaml.external.biz.base64Coder.Base64Coder;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.PasteUtil;
import java.io.BufferedWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;

public class Commandcreatekit
extends EssentialsCommand {
    public Commandcreatekit() {
        super("createkit");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length != 2) {
            throw new NotEnoughArgumentsException();
        }
        long delay = Long.parseLong(args[1]);
        String kitname = args[0];
        ItemStack[] items = Inventories.getInventory(user.getBase(), true);
        ArrayList<String> list = new ArrayList<String>();
        boolean useSerializationProvider = this.ess.getSettings().isUseBetterKits();
        if (useSerializationProvider && this.ess.getSerializationProvider() == null) {
            this.ess.showError(user.getSource(), new Exception(I18n.tl("createKitUnsupported", new Object[0])), commandLabel);
            useSerializationProvider = false;
        }
        for (ItemStack is : items) {
            if (is == null || is.getType() == null || is.getType() == Material.AIR) continue;
            String serialized = useSerializationProvider ? "@" + Base64Coder.encodeLines(this.ess.getSerializationProvider().serializeItem(is)) : this.ess.getItemDb().serialize(is);
            list.add(serialized);
        }
        if (!this.ess.getSettings().isPastebinCreateKit()) {
            this.ess.getKits().addKit(kitname, list, delay);
            user.sendMessage(I18n.tl("createdKit", kitname, list.size(), delay));
        } else {
            this.uploadPaste(user.getSource(), kitname, delay, list);
        }
    }

    private void uploadPaste(CommandSource sender, String kitName, long delay, List<String> list) {
        this.ess.runTaskAsynchronously(() -> {
            try {
                StringWriter sw = new StringWriter();
                YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().sink(() -> new BufferedWriter(sw))).indent(2).nodeStyle(NodeStyle.BLOCK).build();
                Object config = loader.createNode();
                config.node("kits", kitName, "delay").set(delay);
                config.node("kits", kitName, "items").set(list);
                sw.append("# Copy the kit code below into the kits section in your config.yml file\n");
                loader.save((ConfigurationNode)config);
                String fileContents = sw.toString();
                CompletableFuture<PasteUtil.PasteResult> future = PasteUtil.createPaste(Collections.singletonList(new PasteUtil.PasteFile("kit_" + kitName + ".yml", fileContents)));
                future.thenAccept(result -> {
                    if (result != null) {
                        String separator = I18n.tl("createKitSeparator", new Object[0]);
                        String delayFormat = delay <= 0L ? "0" : DateUtil.formatDateDiff(System.currentTimeMillis() + delay * 1000L);
                        sender.sendMessage(separator);
                        sender.sendMessage(I18n.tl("createKitSuccess", kitName, delayFormat, result.getPasteUrl()));
                        sender.sendMessage(separator);
                        if (this.ess.getSettings().isDebug()) {
                            this.ess.getLogger().info(sender.getSender().getName() + " created a kit: " + result.getPasteUrl());
                        }
                    }
                });
                future.exceptionally(throwable -> {
                    sender.sendMessage(I18n.tl("createKitFailed", kitName));
                    this.ess.getLogger().log(Level.SEVERE, "Error creating kit: ", (Throwable)throwable);
                    return null;
                });
            }
            catch (Exception e) {
                sender.sendMessage(I18n.tl("createKitFailed", kitName));
                this.ess.getLogger().log(Level.SEVERE, "Error creating kit: ", e);
            }
        });
    }
}

